/**
 * Receipt Cancel Request Window
 * @author Amit G
 */
Ext.define('Academia.view.feeandpayment.receipts.ReceiptCancelConfirmationWindow', {
	extend : 'Ext.window.Window',
	alias : 'widget.receiptcancelconfirmationwindow',
	title:getFeeAndPaymentCommonTranslation('RECEIPT_CANCELLATION'),
	modal: true,
    resizable: false,
    autoScroll: true,
    frame: true,
    maxHeight : 550,
    items: [{
		xtype:'form',
		plugins : "formlabelrequired",
		items : [{
			xtype: 'fieldcontainer',
			layout: 'vbox',
			width:'100%',
			defaults: {
				labelAlign: 'top',
				xtype :'displayfield',
			},
			items:[{
                style: {
                    height: '46px !important',
                    textAlign: 'justify'
                },
                flex:1,
                value: '<p style=\'font: bold 14px/17px Open Sans, sans-serif, Myriad Pro;margin:0px;\'>Canceling this will reverse all associated settlements and accounting status.</p>',
            },{
                style: {
                    height: 'auto',
                    textAlign: 'justify'
                },
                flex:1,
                value: '<p style=\'font: bold 14px/17px Open Sans, sans-serif, Myriad Pro;margin:0px;\'>Are you sure you want to cancel settlement?</p>',
            }]    
		},/*{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				labelAlign: 'top',
				xtype :'displayfield',
			},
			items:[{
                style: {
                    height: 'auto',
                    textAlign: 'justify'
                },
                flex:1,
                value: '<p style=\'font: bold 14px/17px Open Sans, sans-serif, Myriad Pro;margin:0px;\'>Are you sure you want to cancel settlement?</p>',
            }]    
		},*/{
    	xtype : 'fieldcontainer',
    	layout:'hbox',
		defaults : {
			labelAlign : 'top'
		},
		items : [ {
			xtype: 'hidden',
			itemId: 'id'
		},{	
		xtype: 'textarea',
		width: 536,
		name: 'reasonForCancelReceipt',
		itemId:'reasonForCancelReceipt',
		allowBlank:false,
		cls:'receiptCancelBoxCLSItalic',
		maxLength: 500,
		fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_CANCELLATION_REASON_TITLE_BOTTOM'),
		
	}]},{
    	xtype : 'fieldcontainer',
		width : 'auto',
		cls : 'windowBtnPos',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SUBMIT'),
			itemId : 'submitButtonId',
			buttonAlign : 'left',
			ui : 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind: true
			
		}, {
			xtype: 'button',
			text : getCommonTranslation('CANCEL'),
			itemId : 'cancelButtonId',
			buttonAlign : 'left',
			ui : 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		} ]
	}]
    }]
});