/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.receipts.ReceiptHeaderListForSponsor', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.receiptheaderlistforsponsor',
	store : 'feeandpayment.receipts.ReceiptHeaderForSponsor',
	border: true,
	title: getCommonTranslation('LIST_OF_RECEIPT'),
	isGridConfigurable: true,
	enableColumnHide: false,
	autoScroll: false,
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
//	style: {overflowX: 'auto', overflowY: 'hidden'},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	 features: [{
	        ftype: 'summary',
	        showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
	    }],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.receipts.ReceiptHeaderForSponsor',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);     
 },
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId:'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
	    glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		/*xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH*/
		xtype: 'button',
		itemId: 'btnDelete',
		text: getCommonTranslation('CANCEL'),
		cls: 'CustomBtnCancel',
		scale: CONSTANTS.BUTTONSIZE
	},'->',{
		xtype: 'button',
		itemId: 'btnPrint',
		disabled:true,
		icon: 'resources/images/print1.png',
		tooltip: getFeeAndPaymentCommonTranslation('PRINT_RECORD')
	}],
	columns: [{
		header : getCommonTranslation('ACADEMY'),
		dataIndex : 'academyName',
		flex : 1,
		summaryRenderer: function(value, metaData, record, row, col, store, gridView)  {
			if(!isNullOrEmpty(store.data.items[0].data.acadLocBaseCurrencyId)&&store.data.items[0].data.acadLocBaseCurrencyId!=0){
								return getFeeAndPaymentCommonTranslation('Total(In '+store.data.items[0].data.acadCurrencyName+')');	
	
			}
			else{

				return getFeeAndPaymentCommonTranslation('Total');
			}
		}
	},{
		header : getCommonTranslation('LOCATION'),
		dataIndex : 'locationName',
		flex : 1
	},
	{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programPrintName',
		flex : 1,
		hidden : true
	},{
		header : getCommonTranslation('SPONSOR_NAME'),
		dataIndex : 'sponsorName',
		flex : 1
	},{
    	header : getCommonTranslation('RECEIPT_NUMBER'),
 		dataIndex : 'receiptNo',
 		flex : 1	 
     },{
    	 header : getCommonTranslation('RECEIPT_MODE'),
    	 dataIndex : 'receiptType',
     	 flex : 1,
     	renderer:function(value, metaData, record, rowIndex, colIndex, view){
			metaData.style = "white-space: normal;";
			return getCommonTranslation(value);
		}
     },{
    	 header : getCommonTranslation('SETTLEMENT_STATUS'),
    	 dataIndex : 'status',
     	 flex : 1,
     	renderer:function(value, metaData, record, rowIndex, colIndex, view){
			metaData.style = "white-space: normal;";
			return getCommonTranslation(value);
		}
     },{
		header : getCommonTranslation('CANCELLATION_REASON'),
		dataIndex : 'cancellationNarration',
		flex : 2,
		hidden:true
	},{
    	header : getCommonTranslation('AMOUNT'),
 		dataIndex : 'amount',
 		flex : 1.8,
 		summaryType: 'sum',
 		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
 		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(store.data.items[0].data.acadLocBaseCurrencyId) && store.data.items[0].data.acadLocBaseCurrencyId!=0)
			{
				metaData.column.summaryType='';
			}
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
 		
     },{
    	 header : getCommonTranslation('CURRENCY_EXCHANGE_RATE'),
    		dataIndex : 'currencyExchangeRate',
    		flex : 1.2,
    		
      },{
       	 header : getCommonTranslation('CONVERTED_AMOUNT'),
			dataIndex : 'convertedAmountRandB',
			flex : 1.2,
			summaryType : 'sum',
			renderer:function(value, metaData, record, row, col, store, gridView){
				if(!isNullOrEmpty(value)){
					return currencyRenderer(value,record.get("acadLocBaseCurrencyId"));
				}
			},
			summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
				if(!isNullOrEmpty(store.data.items[0].data.acadLocBaseCurrencyId)){
					return currencyRenderer(value,store.data.items[0].data.acadLocBaseCurrencyId);
				}
				else{
					return '';
				}
			}
      },{
    	header : getCommonTranslation('RECEIPT_DATE'),
 		dataIndex : 'transactionDate',
 		flex : 1,
 		renderer: function(date) {
            return dateRender(date);
        }
     },{
		header : getCommonTranslation('REMARKS'),
		dataIndex : 'remarks',
		flex : 1
	},{
    	 header : getCommonTranslation('PAYMENT_MODE'),
     	 dataIndex : 'paymentModeName',
     	 flex : 1,
     	 hidden : true
     },{
		header : getCommonTranslation('OUR_BANK_ACCOUNT'),
		dataIndex : 'bankName',
		flex : 1,
		hidden: true
	},{
    	 header : getCommonTranslation('RECEIPT_CURRENCY'),
     	 dataIndex : 'currencyName',
     	 flex : 1,
     	 hidden : true
     },{
    	 header : getCommonTranslation('ADJUSTMENT_DETAILS'),
     	 dataIndex : 'adjustmentDetails',
     	 flex : 1,
     	renderer : function(value){
			  return  '<a href="#">'+"View"+'</a>';
		}
     },{
    	 header : getCommonTranslation('INSTRUMENT_DETAILS'),
     	 dataIndex : 'instrumentDetails',
     	 flex : 1,
     	 renderer : function(value, metaData, record, row, col, store, gridView){
     	 if(record.data.voucherMode=="BANK"){
			  return  '<a href="#">'+"View"+'</a>';
   		 }else{
   			return value;
   		}}
     },
     {
    	 header : getCommonTranslation('COST_CENTER'),
    	 dataIndex : 'costCentre',
    	 flex : 1,
    	 hidden : true
     },
     {
    	 header : getFeeAndPaymentCommonTranslation('EXTERNAL_RECEIPT_NO'),
    	 dataIndex : 'externalReceiptNo',
    	 flex : 1,
    	 hidden : true
     }]
});