/**
 *  @author Rohit.Thadani
 */
Ext.define('Academia.view.feeandpayment.reports.ApplicantBillDiscountDetailListGrid', {
	//extend : 'Ext.grid.Panel',
	extend:'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.applicantbilldiscountdetaillistgrid',
	store : 'feeandpayment.managebill.DiscountEntry',
	border: true,
	//autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:true 
	}],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.managebill.DiscountEntry',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
    tbar: [],
	columns: [{
				header : getFeeAndPaymentCommonTranslation('DISCOUNT_DATE'),
				dataIndex : 'discountDate',
				flex : 0.6,
				renderer : function(discountDate){
					if(discountDate){
					    return dateRender(discountDate);
					}
				},
				align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
//				summaryRenderer: function(value, summaryData, dataIndex) {
//					return getFeeAndPaymentCommonTranslation('GRAND_TOTAL');
//				}
				summaryRenderer: function(value, metaData, record, row, col, store, gridView)  {
					if(store.data.items[0].data.conversionType == "AL") {
						return getFeeAndPaymentCommonTranslation('Grand Total (In ' + store.data.items[0].data.currencyName +')');
					}
					else {
						return getFeeAndPaymentCommonTranslation('GRAND_TOTAL');
					}
				}
			  }/*,{
	        	header : getFeeAndPaymentCommonTranslation('DISCOUNT_CODE'),
	     		dataIndex : 'discountCode',
	     		flex : 0.6,
	     		renderer : function(value){
	     			if(value){
	     			    return value.value;
	     			}
	     		}
	         }*/,{
	        	 header : getFeeAndPaymentCommonTranslation('DISCOUNT_AMOUNT'),
		     	 dataIndex : 'discountAmount',
		     	 flex : 0.6,
		     	 renderer:function(value, metaData, record, row, col, store, gridView){
					return currencyRenderer(value,record.get("currencyId"));
				 },
				 summaryType: 'sum',
				 align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
//				 summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
//					 return currencyRenderer(value,summaryData.record.get("currencyId"));
//				 },
				 summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
					if(store.data.items[0].data.conversionType == 'EX') {
						return currencyRenderer(value, store.data.items[0].data.currencyId);
					}
					else {
						return '';
					}
				}
	         },{
	     		header : getFeeAndPaymentCommonTranslation('CURRENCY_EXCHANGE_RATE'),
	    		dataIndex : 'currencyExchangeRate',
	    		flex:1.0,
	    		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
	    	},
	         {
	        	 header : getFeeAndPaymentCommonTranslation('CONVERTED_DISCOUNT_AMOUNT'),
		     	 dataIndex : 'convertedDiscountAmount',
		     	 flex : 0.6,
		     	summaryType: 'sum',
		     	 /*renderer:function(value, metaData, record, row, col, store, gridView){
					return currencyRenderer(value,record.get("currencyId"));
				 },
				 align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
				 summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
					 return currencyRenderer(value,summaryData.record.get("currencyId"));
				 },*/
		     	renderer:function(value, metaData, record, row, col, store, gridView){
					if(!isNullOrEmpty(value)){
						return currencyRenderer(value,record.get("baseCurrencyId"));
					}
				},
				summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
					if(store.data.items[0].data.conversionType == 'AL'){
						return currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
					}
					else {
						return '';
					}
				}
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('DISCOUNT_GIVEN_BY'),
		     	 dataIndex : 'discountGivenBy',
		     	 flex : 0.6,
		     	renderer : function(discountGivenBy){
	     			if(discountGivenBy){
	     			    return discountGivenBy.value;
	     			}
	     		}
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('DISCOUNT_REMARK'),
		     	 dataIndex : 'reasonForDiscount',
		     	 flex : 0.6,
		     	renderer : function(reasonForDiscount){
	     			if(reasonForDiscount){
	     			    return reasonForDiscount;
	     			}
	     		}
	         }]
});