/**
 * @author sanjeev ranjan
 */
Ext.define('Academia.view.feeandpayment.reports.CourseWiseFeeReportForm', {
	extend : 'Ext.form.FormPanel',
	alias : 'widget.coursewisefeereportform',
	autoScroll : false,
	frame : false,
	cls : 'customSearchPanel',
	method : 'GET',
	standardSubmit : false,
	defaults : {
		labelAlign : 'top',
		width: 256
	},
	plugins : "formlabelrequired",
	items : [ {
		xtype : 'fieldcontainer',
		layout : 'hbox',
		width : '100%',
		defaults : {
			labelAlign : 'top',
			width: 256
		},
		style:{'margin-left':'18px'},
		items : [ {
			xtype: 'customcombobox',
			name: 'academicTerm',
			itemId:'academicTermId',
			fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
//	        translationKey:'COURSE_DEPARTMENT',
			store:Ext.create('Academia.store.feeandpayment.AcademicTermStore'),
			editable: true,
			valueField: 'academicTermId',
			displayField: 'academicTermName',
			allowBlank: false,
			typeAhead:true,
			forceSelection:true,
			disabled:false,
			hideTrigger:false,	 
			allowBlank:false,
//			queryParam:'qry',
			triggerAction: 'all',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]},
		{
		width : '100%',
		cls : 'customSearchInnerPanel',
		items : [{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			width : '100%',
			defaults : {
				labelAlign : 'top',
				width: 256
			},
			items : [ 
				{
		    		xtype: 'customcombobox',
		    		width: 536,
		    		name:'programNameOrCode',
		    		store : Ext.create('Academia.store.feeandpayment.ProgramTermStore'),
		    		itemId:'programNameOrCodeQuickFiltr',
		    		fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		    		valueField: 'programId',
		    		displayField: 'programName',
		    		queryParam:'qry',
		    		minChars:3,
		    		allowBlank: true,
		    		typeAhead:false,
		    		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    		forceSelection:true,
		    		listConfig: {
		    			listeners: {
		    				beforeshow: function(picker) {
		    					picker.minWidth = picker.up('combobox').getSize().width;
		    				}
		    			},
		    			loadingText: getCommonTranslation('SEARCHING'),
		    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    			getInnerTpl: function() {
		    				return '<div class="search-item">' +
		    				'{code} / {value}'+ 
		    				'</div>';
		    			}
		    		}

		    	},
		    	
			  {
				xtype : 'customcombobox',
				name : 'batchId',
				itemId : 'batchId',
				fieldLabel : getFeeAndPaymentCommonTranslation('BATCH'),
				disabled : false,
				store : Ext.create('Academia.store.feeandpayment.BatchTermStore'),
				valueField : 'batchId',
				displayField : 'batchName',
				typeAhead : true,
				forceSelection : true
			},
			{
				xtype: 'customcombobox',
				name: 'period',
				itemId : 'periodId',
				fieldLabel: getCommonTranslation('PERIOD'),
				store : Ext.create('Academia.store.feeandpayment.periodTermStore'),
				displayField : 'programPeriodName',
				valueField : 'periodId',
				//allowBlank: false,

			}]}
	]
		}
		,
		{
			width : '100%',
			cls : 'customSearchInnerPanel',
			items : [{
				xtype : 'fieldcontainer',
				layout : 'hbox',
				width : '100%',
				defaults : {
					labelAlign : 'top',
					width: 256
				},
				items : [ 
					{
						xtype: 'multiselectcombofield',
						name: 'courseCodeName',
						itemId: 'courseCodeNameId',
						fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
						valueField: 'courseId',
						displayField: 'courseName',
						store : Ext.create('Academia.store.feeandpayment.CourseCodeNameStore'),
						width:410,
						queryParam:'qry',
						typeAhead : true,
						allowBlank:true,
						forceSelection:true,
						hideTrigger:false,
						triggerAction: 'all',
						autoloadStore: false,
						minChars:3,
						disabled:true,
						cls:'ProgramCourseMultiselectField',
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						listConfig: {
			    			listeners: {
			    				beforeshow: function(picker) {
			    					picker.minWidth = picker.up('combobox').getSize().width;
			    				}
			    			},
			    			loadingText: getCommonTranslation('SEARCHING'),
			    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			    			getInnerTpl: function() {
			    				return '<div class="search-item">' +
			    				'{code} / {value}'+ 
			    				'</div>';
			    			}
			    		}
					},
					{

						 xtype: 'customcombobox',
							width: 256,
							name: 'CourseFeeDefination',
							itemId:'CourseFeeDefinationId',
							store : Ext.create('Academia.store.feeandpayment.CourseFeeDefinationStore'),
							fieldLabel: getCommonTranslation('COURSE_FEE_DEFINITION'),
							valueField: 'courseDefinitionId',
							displayField: 'courseDefinitionName',
							allowBlank: true,
							typeAhead: false,
							queryParam:'name',
							rowIndx:0,
							minChars:3,
							disabled:true,
				            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				            forceSelection:true,
							  listConfig: {
								  listeners: {
										beforeshow: function(picker) {
											picker.minWidth = picker.up('combobox').getSize().width;
										}
									},
					                loadingText: getCommonTranslation('SEARCHING'),
					                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					                getInnerTpl: function() {
					                    return '<div class="search-item">' +
					                        '{value}' +
					                    '</div>';
					                }
					            }
						
						
						
					}]}
		]
			},
		{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			layout: 'hbox',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				//buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,  
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
}
);
