/**
 * @author Deepak Nigam
 */
Ext.define('Academia.view.feeandpayment.reports.DependentFeeCollectionReportForm', {
	extend : 'Ext.form.FormPanel',
	alias : 'widget.dependentfeecollectionreportform',
	autoScroll : false,
	frame : false,
	cls : 'customSearchPanel',
	method : 'GET',
	standardSubmit : false,
	defaults : {
		labelAlign : 'top',
		width: 256
	},
	plugins:"formlabelrequired",
	items:[{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top',
			/*//xtype: 'numberfield',
			hideTrigger:true,
			mouseWheelEnabled:false,
			//allowDecimals:false,
			//allowExponential:false

			 */			},
			 items:[{
				 xtype : 'radiogroup',
				 name:'selectType',
				 layout:'hbox',
				 width: 536,
				 itemId:'selectTypeItemId',
				 fieldLabel:getFeeAndPaymentCommonTranslation('VIEW_RECIEPT_FOR'),
				 defaults: {
					 flex: .1
				 },
				 items : [
				   {
					boxLabel : getFeeAndPaymentCommonTranslation('ALL'),
					name : 'recieptFor',
					inputValue : 'all',
					 checked : true

					}
				  ,{
					 boxLabel : getFeeAndPaymentCommonTranslation('STUDENT'),
					 name : 'recieptFor',
					 inputValue : 'student'
					

				 },{
					 boxLabel : getFeeAndPaymentCommonTranslation('APPLICANT'),
					 name : 'recieptFor',
					 inputValue : 'applicant'
				 }
				]
			 }]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{

			xtype : 'customcombobox',
			name : 'intakeyear',
			itemId: 'intakeyear',
			fieldLabel : getFeeAndPaymentCommonTranslation('INTAKE_YEAR'),
			store: Ext.create('Academia.store.common.IntakeYearStore'),
			valueField : 'id',
			displayField : 'value',
			allowBlank : true,
			width: 256
		
		},{
			xtype: 'customcombobox',
			name: 'student',
			itemId:'student',
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: 'feeandpayment.reports.Student',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			hidden:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			//allowBlank : false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode}/{studentName}' +
					'</div>';
				}
			}
		},{
            xtype: 'statusCombo',
            name: 'STATUS',
            itemId:'statusComboItemId',
            value:null
		},{
			xtype: 'customcombobox',
			name: 'applicant',
			itemId:'applicant',
			hidden:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT_NAME_OR_CODE'),
			store: 'feeandpayment.reports.Applicant',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
		    	   xtype: 'customcombobox',
		    	   name: 'paymentMode',
		    	   itemId:'paymentMode',
		    	   fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_MODE'),
		    	   store:'feeandpayment.FeePaymentMode',
		    	   valueField: 'id',
		    	   displayField: 'value',
		    	   typeAhead:true,
		    	   hidden:true,
		    	   forceSelection:true 
		       }]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[/*
			{
				xtype : 'customcombobox',
				name : 'academicYear',
				itemId: 'academicYear',
				fieldLabel : getFeeAndPaymentCommonTranslation('ACADEMIC_YEAR'),
				store : 'program.programDetails.programBatches.PrimaryAcademicStore',
				valueField : 'id',
				displayField : 'yearName',
				allowBlank : true,
				width: 256
			},{
				xtype : 'customcombobox',
				name : 'academyYearTenure',			
				itemId : 'academyYearTenure',			
				fieldLabel : getCommonTranslation('ACADEMY_YEAR_TENURE'),//Current Academic Year Tenure
				store : 'organization.academylocations.AcademicTenureStore',
				valueField : 'id',
				displayField : 'tenureName',
				editable:false
			}*/]},
			{
				xtype:'fieldcontainer',
				layout:'hbox',
				width: '100%',
				defaults: {
					width: 256,
					labelAlign: 'top'
				},
				items:[{
					xtype: 'datefield',
					name: 'fromdate',
					itemId:'fromdate',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype: 'daterange',
					endDateField: 'todate',
					editable:false,
					fieldLabel: getFeeAndPaymentCommonTranslation('FROM_DATE')
				},{
					xtype: 'datefield',
					name: 'todate',
					itemId:'todate',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype: 'daterange',
					startDateField: 'fromdate',
					editable:false,
					fieldLabel: getFeeAndPaymentCommonTranslation('TILL_DATE')
				}, {
					xtype: 'multiselectcombofield',
					name: 'dependentFeeHead',
					itemId:'dependentFeeHeadId',
					autoloadStore: false,
					fieldLabel: getFeeAndPaymentCommonTranslation('DEPENDED_FEE_HEAD'),
					store:'feeandpayment.DependedFeeHead',
		    		valueField: 'id',
		    		displayField: 'value',
		    		cls:'commonAutoHeightMultiselectField',
		    		queryParam:'dependentFeeHead',
		    		typeAhead:true,
		    		triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					hideTrigger:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR')
				}]},
	   {
		xtype:'fieldset',
		title: getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '33px!important'},
		width:'100%',
		listeners:{
			expand:function(cmp){
				Ext.defer(function(){
					cmp.up('studentfeereportfinalstructure').doLayout();
					cmp.up('studentfeereportfinalstructure').updateLayout();
				},100);
				
			}
		},
		items: [{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width: 256
			},
			items:[
			       {
			    	   xtype:'customcombobox',
			    	   name:'programId',
			    	   itemId:'programId',
			    	   width: 536,
			    	   fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			    	   store:Ext.create('Academia.store.feeandpayment.reports.ProgramStudentByIntakeYearStore'),
			    	   displayField:'valueCode',
			    	   valueField:'id',
			    	   typeAhead:true,
			    	   forceSelection:true,
			    	   hideTrigger:false,
			    	   triggerAction: 'all',
			    	   minChars:3,
			    	   queryParam:'programName',
			    	   emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			    	   listConfig: {
							  listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								},
				                loadingText: getCommonTranslation('SEARCHING'),
				                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				                getInnerTpl: function() {
				                    return '<div class="search-item">' +
				                    '{code} / {value}'  +
				                    '</div>';
				                }
				            }
			       },{
			    	   xtype: 'customcombobox',
			    	   name: 'batchId',
			    	   disabled:true,
			    	   fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
			    	   itemId:'batchId',
			    	   store: 'enquiry.AcademicBatchStore',
			    	   valueField: 'id',
			    	   displayField: 'value',
			    	   typeAhead:true,
			    	   forceSelection:true
			       }]
		 },{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name: 'seatTypeId',
				disabled:true,
				itemId:'seatTypeId',
				fieldLabel: getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
				store: Ext.create('Academia.store.feeandpayment.reports.ProgramBatchSeatIdByBatchStudentIdStore'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			}/*,{
				xtype: 'customcombobox',
				name: 'voucherMode',
				itemId:'voucherMode',
				fieldLabel: getFeeAndPaymentCommonTranslation('VOUCHER_MODE'),
				store:'feeandpayment.payment.VoucherMode',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			}*/]
		}]
	},
	{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}


	]
});
