/**
 * @author Nitin Gaikwad
 */
Ext.define('Academia.view.feeandpayment.reports.InstruemntDetailReportGrid',
				{
					extend : 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
					alias : 'widget.instruemntdetailreportgrid',
					store : 'feeandpayment.reports.InstrumentDetailReport',
					title : getFeeAndPaymentCommonTranslation('INSTRUMENT_DETAIL_REPORT'),
					cls:'centerAlignTitle',
					border : true,
					autoScroll : false,
					refreshStoreData:true,
					isGridConfigurable: true,
					enableColumnHide: false,
					viewConfig : {
						stripeRows : CONSTANTS.STRIPEROWS
					},
					features: [{
						ftype: 'summary',
						showSummaryRow:false 
					}],
					dockedItems : [ {
						xtype : 'toolbar',
						dock : 'bottom',
						items : [{
							xtype : 'custompagingtoolbar',
							plugins : [ 'pagesize' ],
							store : 'feeandpayment.reports.InstrumentDetailReport',
							emptyMsg : getCommonTranslation('EMPTY_MESSAGE'),
							displayInfo : true
						}]
					} ],
					initComponent : function() {
						var grid = this;
						grid.addExportToolBarItems(grid);
						this.callParent(arguments);
					},
					columns : [
							{
								header : getCommonTranslation('ADMISION_ID'),
								dataIndex : 'admissionCode',
								hidden:true,
								flex : 1
							},
							{
								header : getCommonTranslation('RECEIPT_NUMBER'),
								dataIndex : 'receiptNo',
								flex : 1,
								renderer : function(value) {
									if (value) {
										return '<a href="#">' + value + '</a>';
									}
								},
								summaryRenderer: function(value, metaData, record, row, col, store, gridView){
						            // return getFeeAndPaymentCommonTranslation('TOTAL');

									if(store.data.items[0].data.conversionType == "AL" || store.data.items[0].data.conversionType == "ORG") {
									// a = currencyRenderer('',store.data.items[0].data.acadLocBaseCurrencyId).split(" ");
										return getFeeAndPaymentCommonTranslation('Total (In ' + store.data.items[0].data.currencyName +')');
									}
									else {
										return getFeeAndPaymentCommonTranslation('TOTAL');
									}
								
						         }
							},
							{
								header : getCommonTranslation('RECEIPT_DATE'),
								dataIndex : 'receiptDate',
								flex : 1,
								renderer : function(date) {
									return dateRender(date);
								}
							},
							{
								header : getCommonTranslation('RAISE_BILL_TYPE'),
								dataIndex : 'raiseBillType',
								hidden:true,
								flex : 1
							},
							{
								header : getCommonTranslation('USER_TYPE'),
								dataIndex : 'userType',
								flex : 1
							},
							{
								header : getCommonTranslation('USER_CODE'),
								dataIndex : 'code',
								flex : 1
							},
							{
								header : getCommonTranslation('COMMITTEE_PARTICIPANT_NAME'),
								dataIndex : 'printName',
								flex : 1
							},
							{
								header : getCommonTranslation('PROGRAM'),
								dataIndex : 'programName',
								hidden:true,
								flex : 1
							},
							{
								header : getCommonTranslation('AVAILABLE_PAYMENT_MODE'),
								dataIndex : 'paymentModeName',
								flex : 1
							},
							{
								header : getCommonTranslation('INSTRUMENT_NO'),
								dataIndex : 'instrumentNo',
								flex : 1
							},
							{
								header : getCommonTranslation('INSTRUMENT_DATE'),
								dataIndex : 'instrumentDate',
								flex : 1,
								renderer : function(date) {
									return dateRender(date);
								}
							},
							{
								header : getCommonTranslation('RECEIPT_AMOUNT'),
								dataIndex : 'receiptAmount',
								hidden : true,
								flex : 1.8,
								summaryType : 'sum',
								//align : CONSTANTS.AMOUNT_COLUMN_ALIGN,
								/*
								 * summaryRenderer: function (value,
								 * summaryData, dataIndex, rowIndex, colIndex,
								 * store, view) { return value; },
								 */
								renderer : function(value, metaData, record,
										row, col, store, gridView) {
									if (!isNullOrEmpty(value)) {
										return currencyRenderer(value, record
												.get("currencyId"));
									}
								},
							},
							{
								header : getCommonTranslation('INSTRUMENT_AMOUNT'),
								dataIndex : 'instrumentAmount',
								flex : 1.8,
								summaryType : 'sum',
								//align : CONSTANTS.AMOUNT_COLUMN_ALIGN,
								/*
								 * summaryRenderer: function (value,
								 * summaryData, dataIndex, rowIndex, colIndex,
								 * store, view) { return value; },
								 */
								renderer : function(value, metaData, record,
										row, col, store, gridView) {
									if (!isNullOrEmpty(value)) {
										return currencyRenderer(value, record
												.get("currencyId"));
									}
								},
								summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
									if(store.data.items[0].data.conversionType == 'EX'){
										return currencyRenderer(value, store.data.items[0].data.orgCurrency);
									}
									else {
										return '';
									}
								}
							},
							{

								header : getCommonTranslation('CURRENCY_EXCHANGE_RATE_DETAIL'),
								dataIndex : 'currencyExchangeRate',
								flex : 1.2,

							},
							{

								header : getCommonTranslation('CONVERTED_INSTRUMENT_AMOUNT'),
								dataIndex : 'convertedInstrumentAmount',
								flex : 1.2,
								summaryType : 'sum',
								renderer:function(value, metaData, record, row, col, store, gridView){
									if(!isNullOrEmpty(value)){
									     return currencyRenderer(value,record.get("baseCurrencyId"));}
								},
								summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
//				
									if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG'){
										return currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
									}
									else {
										return '';
									}
								
								}

							
							},
							{
								header : getCommonTranslation('BANK'),
								dataIndex : 'instrumentBank',
								flex : 1,
								renderer : function(value, metaData, record,
										row, col, store, gridView) {
									if (record.data.instrumentBank==null) {
										return 'Others';
									} else {
										return value;
									}
								}
								
							},
							{
								header : getCommonTranslation('NARRATION'),
								hidden:true,
								dataIndex : 'narration',
								flex : 1
							},
							{
								header : getCommonTranslation('DATE_OF_ADMISSION'),
								dataIndex : 'admissionDate',
								hidden:true,
								flex : 1,
								renderer : function(date) {
									return dateRender(date);
								}
							}

					]

				});
