/**
 * @author harsh.Nagra
 */
Ext.define('Academia.view.feeandpayment.reports.PaymentPlanReportDetailsWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.paymentplanreportdetailswindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	//height: 'auto',
	height: '40%',
	width: '80%',
	frame: true,
	title:getCommonTranslation('PAYMENT_DETAILS'),
	items: [{
		xtype: 'grid',
		store : 'feeandpayment.reports.PaymentPlanReportDetailsStore',
		autoScroll: true,
		itemId : 'paymentplanreportdetailswindowid',
		border: true,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		 features: [{
		        ftype: 'summary',
		        showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
		    }],
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store : 'feeandpayment.reports.PaymentPlanReportDetailsStore',
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
		columns: [{
			header : getCommonTranslation('S_NO'),
			dataIndex: 'sequence',
			align:'center',
			sortable: false,
			flex : 1  
		},{
			header : getFeeAndPaymentCommonTranslation('AMOUNT_PAID'),
			dataIndex : 'amount',
			sortable: false,
			flex : 1,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)) {
					return currencyRenderer(value,record.get("currencyId"));
				}                      
			} 
		},{ 
			header : getFeeAndPaymentCommonTranslation('FEE_ADJUSTMENT_AMOUNT'),
			dataIndex : 'feeAdjustedAmount',
			sortable: false,
			flex : 1,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)) {
					return currencyRenderer(value,record.get("currencyId"));
				}                      
			} 
		},{ 
			header : getFeeAndPaymentCommonTranslation('PAYMENT_MODE'),
			dataIndex : 'paymentModeName',
			sortable: false,
			flex : 1, 
			renderer:function(value){
				if(!isNullOrEmpty(value)) {
					return value;
				}   
				else
					{
					return 'CASH';
					}
			} 
		},{ 
			header : getFeeAndPaymentCommonTranslation('ADJUSTMENT_DATE'),
			dataIndex : 'adjustmentDate',
			sortable: false,
			flex : 1,
			renderer:function(value,meta){
				if(!isNullOrEmpty(value)) {
					return dateRender(value);
				}                         
			}
		},{
			header : getFeeAndPaymentCommonTranslation('SETTLEMENT_STATUS'),
			dataIndex : 'status',
			align:'center',
			sortable: false,
			flex : 1,	
			renderer:function(value, metaData, record, rowIndex, colIndex, view){
				metaData.style = "white-space: normal;";
				return getCommonTranslation(value);
			}
		}] 	

	}]
});

