/**
 * @author Nitin gaikwad
 */
Ext.define('Academia.view.feeandpayment.reports.StudentDiscountReportForm', {
	extend : 'Ext.form.FormPanel',
	alias : 'widget.studentdiscountreportform',
	autoScroll : false,
	frame : false,
	cls : 'customSearchPanel',
	method : 'GET',
	standardSubmit : false,
	defaults : {
		labelAlign : 'top',
		width: 256
	},
	plugins:"formlabelrequired",
	items:[{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype : 'customcombobox',
			name : 'intakeYear',
			itemId: 'intakeYear',
			fieldLabel : getFeeAndPaymentCommonTranslation('INTAKE_YEAR'),
			store: Ext.create('Academia.store.common.IntakeYearStore'),
			valueField : 'id',
			displayField : 'value',
			allowBlank : true,
			width: 256
		},{
			xtype:'customcombobox',
			name:'feePlanType',
			itemId:'feePlanType',
			fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_TYPE'),
			store:Ext.create('Academia.store.feeandpayment.FeePlanTypeStore'),
			valueField:'id',
			displayField:'value',
			typeAhead:true,
			forceSelection:true
		},
		{
			xtype: 'customcombobox',
			name: 'feeHead',
			itemId:'feeHead',
			fieldLabel: getFeeAndPaymentCommonTranslation('FEES_HEADS'),
			store: Ext.create('Academia.store.feeandpayment.FeeHeads'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},
		]
	},
	{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[
		{
			xtype: 'customcombobox',
			name: 'student',
			itemId:'student',
			width: 256,
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: Ext.create('Academia.store.feeandpayment.reports.Student'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			//allowBlank : false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode}/{studentName}' +
					'</div>';
				}
			}
		},
		{
       	 xtype: 'statusCombo',
            name: 'STATUS',
            itemId: 'statusComboItemId'
		}
	]
	},
	{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name: 'discountCode',
			itemId:'discountCode',
			fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_CODE'),
			store:Ext.create('Academia.store.feeandpayment.DiscountCode'),
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true
		},
		{
            xtype: 'checkboxfield',
            width: 'auto',
            style:{
            	marginTop:'25px'
            },
            labelAlign: 'right',
            itemId:'whetherStudentId',
            boxLabel: getCommonTranslation('ONLY_STUDENT'),
            name: 'whetherStudent',
            inputValue : true
        }]
	},
	{
		xtype:'fieldset',
		title: getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '33px!important'},
		width:'100%',
		listeners:{
			expand:function(cmp){
				Ext.defer(function(){
					cmp.up('studentfeereportfinalstructure').doLayout();
					cmp.up('studentfeereportfinalstructure').updateLayout();
				},100);
				
			}
		},
		items: [{
			xtype:'fieldcontainer',
			layout: 'hbox',
			width: '100%',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'multiselectcombofield',
				name: 'programGroup',
				itemId:'programGroupItemId',
				fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
				store:Ext.create('Academia.store.program.ProgramGroupStore'),
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				width: 536,
				cls:'receiptHeaderMultiselect',
	  			
				typeAhead: true,
	            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
	            enableKeyEvents: 'true',
	            hideTrigger: false,
	            listConfig: {
	                listeners: {
	                    beforeshow: function(picker) {
	                        picker.minWidth = picker.up('combobox').getSize().width;
	                    }
	                },
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{code}' +
	                        '</div>';
	                }
	            }
			}, {
				xtype: 'customcombobox',
				name: 'programCategory',
				itemId:'programCategoryId',
				fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				listeners: {
					render: function(combo) {
						var store = Ext.create('Academia.store.program.ProgramCategoryStore');
						combo.bindStore(store);
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 256,
				labelAlign: 'top',
				/*//xtype: 'numberfield',
				hideTrigger:true,
				mouseWheelEnabled:false,
				//allowDecimals:false,
				//allowExponential:false
*/			},
		items:[
		       {
		    	   xtype:'customcombobox',
		    	   name:'programId',
		    	   itemId:'programId',
		    	   width: 536,
		    	   fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		    	   store:Ext.create('Academia.store.feeandpayment.reports.ProgramStudentByIntakeYearStore'),
		    	   displayField:'valueCode',
		    	   valueField:'id',
		    	   typeAhead:true,
		    	   forceSelection:true,
		    	   hideTrigger:false,
		    	   triggerAction: 'all',
		    	   minChars:3,
		    	   queryParam:'programName',
		    	   emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    	   listConfig: {
						  listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                    '{code} / {value}'  +
			                    '</div>';
			                }
			            }
			   },{
					xtype: 'customcombobox',
					name: 'batchId',
					disabled:true,
					fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
					itemId:'batchId',
					store: Ext.create('Academia.store.enquiry.AcademicBatchStore'),
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true
				}
		       
		       ]
	},
	{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name: 'seatTypeId',
			disabled:true,
			itemId:'seatTypeId',
			fieldLabel: getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
			store: Ext.create('Academia.store.feeandpayment.reports.ProgramBatchSeatIdByBatchStudentIdStore'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'period',
			itemId : 'periodId',
			fieldLabel: getCommonTranslation('PERIOD'),
			store : Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'),
			displayField : 'value',
			valueField : 'id',
			//allowBlank: false,
			disabled : true
		},{
			xtype: 'customcombobox',
			name: 'feePlan',
			itemId:'feePlan',
			fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_NAME'),
			store: Ext.create('Academia.store.feeandpayment.reports.StudentFeePlanReportStore'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true,
			disabled:true
		}]	
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 200,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'datefield',
			name: 'fromdate',
			itemId: 'fromdate',
			vtype: 'daterange',
			endDateField: 'FROM_DATE',
			fieldLabel: getFeeAndPaymentCommonTranslation('FROM_DATE'),
//			allowBlank: false,
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
//			format: CONSTANTS.DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}, {
			xtype: 'datefield',
			name: 'todate',
			itemId: 'todate',
			vtype: 'daterange',
			startDateField: 'TILL_DATE',
			fieldLabel: getFeeAndPaymentCommonTranslation('TILL_DATE'),
//			allowBlank: false,
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
//			format: CONSTANTS.DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]
	}]
	},
	{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});
