/**
 * @author Nitin gaikwad
 */
Ext.define('Academia.view.feeandpayment.reports.UserWiseCollectionReportForm', {
	extend : 'Ext.form.FormPanel',
	alias : 'widget.userwisecollectionreportform',
	autoScroll : false,
	frame : false,
	cls : 'customSearchPanel',
	method : 'GET',
	standardSubmit : false,
	defaults : {
		labelAlign : 'top',
		width: 256
	},
	plugins : "formlabelrequired",
	items : [{
		xtype : 'fieldcontainer',
		layout : 'hbox',
		width : '100%',
		items : [{
			xtype : 'radiogroup',
			name:'selectType',
			labelAlign:'top',
			layout:'hbox',
			width: 536,
			itemId:'selectCollectionType',
			items : [{
				boxLabel : getFeeAndPaymentCommonTranslation('ALL_COLLECTION'),
				name : 'selectType',
				inputValue : false

			},{
				boxLabel : getFeeAndPaymentCommonTranslation('MY_COLLECTION'),
				name : 'selectType',
				inputValue : true,
				checked : true
			}]

		}]
	},{
		xtype : 'fieldcontainer',
		layout : 'hbox',
		width : '100%',
		defaults : {
			labelAlign : 'top',
			width: 256
		},
		items : [{
			xtype: 'customcombobox',
			name: 'user',
			itemId:'userId',
			fieldLabel: getFeeAndPaymentCommonTranslation('USER'),
			store:  Ext.create('Academia.store.feeandpayment.reports.User'),
			valueField: 'id',
			displayField: 'nameToBePrinted',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{nameToBePrinted}' +
					'</div>';
				}
			}
		}, {
			xtype: 'customcombobox',
			name: 'voucherMode',
			itemId:'voucherMode',
			fieldLabel: getFeeAndPaymentCommonTranslation('VOUCHER_MODE'),
			store: Ext.create('Academia.store.feeandpayment.payment.VoucherMode'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		}]},
		{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			width : '100%',
			defaults : {
				labelAlign : 'top',
				width: 256
			},
			items : [{
				xtype: 'datefield',
				name: 'fromdate',
				itemId:'fromdate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype: 'daterange',
				endDateField: 'todate',
				editable:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('FROM_DATE')
			},{
				xtype: 'datefield',
				name: 'todate',
				itemId:'todate',
				listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype: 'daterange',
				startDateField: 'fromdate',
				editable:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('TILL_DATE')
			}]
		},
		{
			xtype : 'fieldcontainer',
			width : 'auto',
			layout: 'hbox',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				//buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,  
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
}
);
