/**
 * @author Harsh raghuwanshi
 * 
 */
Ext.define('Academia.view.feeandpayment.reports.VoucherSummaryReportFilter', {
	extend: 'Ext.form.FormPanel',
	alias: 'widget.vouchersummaryreportfilter',
	autoScroll: false,
	frame: false,
	method: 'POST',
	standardSubmit: false,
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	plugins : "formlabelrequired",
	cls:'customSearchPanel',
	items: [{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name: 'organizationUnit',
			itemId:'organizationUnit',
			fieldLabel: getFeeAndPaymentCommonTranslation('IAU'),
			store: 'feeandpayment.accountingConfigurationMapping.IAUAcademyLocationWise',
			valueField: 'id',
			allowBlank : false,
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'voucherType',
			itemId:'SummaryvoucherType',
			fieldLabel: getFeeAndPaymentCommonTranslation('VOUCHER_MODE'),
			store: 'feeandpayment.payment.VoucherMode',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'voucherID',
			itemId:'voucherId',
			fieldLabel: getFeeAndPaymentCommonTranslation('VOUCHER_ID'),
			store: 'feeandpayment.voucherMode.VoucherID',
			valueField: 'id',
			displayField: 'value',
			queryParam:'voucherId',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			forceSelection:true,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: '100%',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name: 'controlAccountId',
			itemId:'controlAccountId',
			fieldLabel: getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT'),
			store: 'feeandpayment.reports.ControlAccountByName',
			valueField: 'id',
			displayField: 'value',
			queryParam:'controlAccount',
			queryMode:'remote',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			forceSelection:true,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'voucherStatus',
			itemId:'voucherStatus',
			fieldLabel: getFeeAndPaymentCommonTranslation('FD_ENTRY_TYPE'),
			store:'feeandpayment.payment.VoucherEntryType',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true 
		}]
	},
	{
		xtype:'fieldset',
		title: getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '33px!important'},
		width:'100%',
		items:[{

			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			itemId:'moredetail',
			defaults: {
				labelAlign:'top',
				width: 256,
				xtype: 'customcombobox'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'voucherTransactionType',
				itemId:'voucherTransactionType',
				fieldLabel: getFeeAndPaymentCommonTranslation('FP_TRANSACTION_TYPE'),
				store:'feeandpayment.voucherMode.VoucherLinkType',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			},
			{
				xtype:'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				itemId:'billDetailId',
				hidden:true,
				defaults: {
					labelAlign:'top',
					width: 256,
					xtype: 'customcombobox'
				},
				items:[{
					name: 'billType',
					itemId:'billType',
					fieldLabel: getFeeAndPaymentCommonTranslation('FP_FEE_TYPE'),
					store:'feeandpayment.managebill.BillType',
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true,
				},{
					name: 'billNo',
					width: 256,
					itemId:'billNo',
					fieldLabel: getFeeAndPaymentCommonTranslation('BILL_NO'),
					store: 'feeandpayment.voucherMode.VoucherBillNo',
					valueField: 'id',
					displayField: 'value',
					queryParam:'billNo',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					forceSelection:true,
					typeAhead:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					hideTrigger:false,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
				}]
			},{
				xtype:'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				itemId:'receiptDetailId',
                hidden: true,
				defaults: {
					labelAlign:'top',
					width: 256,
					xtype: 'customcombobox'
				},
				items:[{
					name: 'receiptType',
					itemId:'receiptType',
					fieldLabel: getFeeAndPaymentCommonTranslation('FP_FEE_TYPE'),
					store:'feeandpayment.voucherMode.VoucherReceiptType',
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true,
				},{

					name: 'receiptNo',
					width: 256,
					itemId:'receiptNo',
					fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_NO'),
					store: 'feeandpayment.voucherMode.VoucherReceiptNo',
					valueField: 'id',
					displayField: 'value',
					queryParam:'receiptNo',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					forceSelection:true,
					typeAhead:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					hideTrigger:false,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
				}]
			},{
				xtype:'fieldcontainer',
				width: '100%',
				itemId:'paymentDetailId',
				hidden:true,
				layout : 'hbox',
				defaults: {
					labelAlign:'top',
					width: 256,
					xtype: 'customcombobox'
				},
				items:[{
					name: 'paymentType',
					itemId:'paymentType',
					fieldLabel: getFeeAndPaymentCommonTranslation('FP_FEE_TYPE'),
					store:'feeandpayment.voucherMode.VoucherPaymentType',
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true,
				},{
					name: 'paymentNo',
					itemId:'paymentNo',
					width: 256,
					fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_NO'),
					store: 'feeandpayment.voucherMode.VoucherPaymentNo',
					valueField: 'id',
					displayField: 'value',
					queryParam:'paymentNo',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					forceSelection:true,
					typeAhead:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					hideTrigger:false,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
				}]
			}]
		
		},{ 
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items:[{
				xtype: 'datefield',
				name: 'fromdate',
				itemId:'fromdate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype: 'daterange',
				endDateField: 'todate',
				editable:false,
				fieldLabel:getFeeAndPaymentCommonTranslation('VOUCHER_DATE_FROM')
			},{
				xtype: 'datefield',
				name: 'todate',
				itemId:'todate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype: 'daterange',
				startDateField: 'fromdate',
				editable:false,
				fieldLabel:  getFeeAndPaymentCommonTranslation('VOUCHER_DATE_TILL')
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			disabled:true,
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});
