/**
 * @author Ranga
 */
Ext.define('Academia.view.feeandpayment.reports.paymentPlanReportForm', {
	extend : 'Ext.form.FormPanel',
	alias : 'widget.paymentplanreportform',
	autoScroll : false,
	frame : false,
	cls : 'customSearchPanel',
	method : 'GET',
	standardSubmit : false,
	defaults : {
		labelAlign : 'top',
		width: 256
	},
	plugins:"formlabelrequired",
	items:[{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
				name:'ADMISSION_NUMBER',
				store:'feeandpayment.reports.AdmissionIdStore',
				fieldLabel: getPersonModuleTranslation('ADMISSION_NUMBER'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
	            //hideTrigger:true,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	            triggerAction: '',
	            forceSelection:true,
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{code} / {value}'  +
		                    '</div>';
		                }
		            }
			

			
            }, {
				xtype: 'customcombobox',
				name: 'STUDENT_ID',
				itemId:'studentId',
				fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
				store: Ext.create('Academia.store.feeandpayment.managebill.StudentDetailsByNationalId'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'studentNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				queryCaching: false, 
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}
            },
		{
            	 xtype: 'customcombobox',
	    			//width: 536,
	    			name:'paymentPlanName',
	    			//store: 'program.ProgramCodeOrNameSmartSearch',
//	    			store: 'program.ProgramByGroupIdStore',
	    			store:Ext.create('Academia.store.feeandpayment.FindAllPaymentPlanStore'),
	    			itemId:'paymentPlanName',
	    			fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_PLAN_NAME'),
//	    			translationKey: 'PROGRAM_CODE_OR_NAME',
	    			valueField: 'id',
	    			displayField: 'valueCode',
	    			queryParam:'query',
	    			minChars:3,
	    			allowBlank: true,
	    			typeAhead:false,
	               // hideTrigger:false,
	                //triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
//	                enableKeyEvents  : 'true',
	                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
//	                triggerAction: '',
	                forceSelection:true,
	    			  listConfig: {
	    				  listeners: {
	    						beforeshow: function(picker) {
	    							picker.minWidth = picker.up('combobox').getSize().width;
	    						}
	    					},
	    	                loadingText: getCommonTranslation('SEARCHING'),
	    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    	                getInnerTpl: function() {
	    	                    return '<div class="search-item">' +
	    	                        '{code} / {value}'+ 
	    	                    '</div>';
	    	                }
	    	            }
	    		
	            }
			
			]
	},{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype : 'customcombobox',
			name : 'intakeyear',
			itemId: 'intakeyear',
			fieldLabel : getFeeAndPaymentCommonTranslation('INTAKE_YEAR'),
			store: Ext.create('Academia.store.common.IntakeYearStore'),
			valueField : 'id',
			displayField : 'value',
			allowBlank : true
		},{
             	xtype: 'customcombobox',
                 name: 'PROGRAM_GROUP',
                 itemId:'programGroupId',
                 fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
                 store:'program.ProgramCategoryIntakeYearALStore',
                 displayField:'value',
                 valueField:'id',
                 allowBlank: true
             },{
		    	   xtype:'customcombobox',
		    	   name:'programId',
		    	   itemId:'programId',
		    	   //width:225,
		    	   fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		    	   store:Ext.create('Academia.store.program.ProgramSortedSequenceWiseStore'),
		    	   displayField:'valueCode',
		    	   valueField:'id',
		    	   typeAhead:true,
		    	   forceSelection:true,
		    	   hideTrigger:false,
		    	   triggerAction: 'all',
		    	   minChars:3,
		    	   queryParam:'qry',
		    	   emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    	   listConfig: {
						  listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                    '{code} / {value}' +
			                    '</div>';
			                }
			            }
			   }]
			},
			
			
			{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
				xtype: 'customcombobox',
				name: 'batchId',
				disabled:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
				itemId:'batchId',
				store: Ext.create('Academia.store.enquiry.AcademicBatchStore'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			},{
			xtype: 'customcombobox',
			name: 'period',
			itemId : 'periodId',
			fieldLabel: getCommonTranslation('PERIOD'),
			store : 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			displayField : 'value',
			valueField : 'id',
			//allowBlank: false,
			disabled : true
		},{
			xtype: 'customcombobox',
			name: 'seatTypeId',
			disabled:true,
			itemId:'seatTypeId',
			fieldLabel: getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
			store: Ext.create('Academia.store.hostel.managehostel.room.RoomDetailSeatTypeStore'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
			}
			]
			},
			
			
	{
		xtype:'fieldset',
		title: getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		//style:{marginTop: '33px!important'},
		width:'100%',
		listeners:{
			expand:function(cmp){
				Ext.defer(function(){
					cmp.up('studentfeereportfinalstructure').doLayout();
					cmp.up('studentfeereportfinalstructure').updateLayout();
				},100);
				
			}
		},
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 256,
				labelAlign: 'top',
			},
		items:[{
                xtype: 'statusCombo',
                name: 'STATUS',
                itemId:'statusComboItemId',
                value:true
            },{
				xtype: 'nestedJsonCombo',
				fieldLabel: getPersonModuleTranslation('NATIONALITY'),
				itemId: 'nationalityCombo',
				store: Ext.create('Academia.store.common.NationalityStore'),
				valueField: 'id',
				displayField: 'value',
				name: 'nationality',
				//queryMode: 'local',
				editable: false
			},{
                xtype: 'numberfield',
                fieldLabel: getPersonModuleTranslation('PHONE_NO'),
                hideTrigger: true,
                keyNavEnabled: false,
                itemId: 'phone_No',
                name: 'PHONE_NO'
            }]
			},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('E_MAIL'),
                name: 'EMAIL_ID',
				vtype: 'email',
				maxLength: '100'

            },{
                xtype: 'customcombobox',
                name: 'GENDER',
                store: Ext.create('Academia.store.common.GenderTypeStore'),
                fieldLabel: getCommonTranslation('GENDER'),
                editable: false,
                valueField: 'id',
                displayField: 'value'
            },
			{
			xtype: 'customcombobox',
			itemId: 'stuPermanentResItemId',
			name: 'isPermanentResident',
			fieldLabel: getCommonTranslation('PERMANENT_RESIDENCY'),
			store : Ext.create('Academia.store.feeandpayment.coursefeedefinition.FeeHeadConfigurationRefundableRuleStore'),
			displayField : 'value',
			valueField : 'id',
			//allowBlank: false,
		}]	
	},
	
	{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			itemId: 'stuAsylumSeekerItemId',
			name: 'isAsylumSeeker',
			fieldLabel: getCommonTranslation('ASYLUM_SEEKER'),
			store : Ext.create('Academia.store.feeandpayment.coursefeedefinition.FeeHeadConfigurationRefundableRuleStore'),
			displayField : 'value',
			valueField : 'id',
			//allowBlank: false,
		}, {
			xtype: 'customcombobox',
			itemId: 'stuAreYouRefugeeItemId',
			name: 'areYouRefugee',
			fieldLabel: getCommonTranslation('REFUGEE'),
			store : Ext.create('Academia.store.feeandpayment.coursefeedefinition.FeeHeadConfigurationRefundableRuleStore'),
			displayField : 'value',
			valueField : 'id',
			//allowBlank: false,
		},
		{
			xtype: 'customcombobox',
			itemId: 'isBursaryRequirementsItemId',
			name: 'isBursaryRequirements',
			fieldLabel: getCommonTranslation('BURSARY_STATUS'),
			store : Ext.create('Academia.store.feeandpayment.coursefeedefinition.FeeHeadConfigurationRefundableRuleStore'),
			displayField : 'value',
			valueField : 'id',
			//allowBlank: false,
		},]
	},
	{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
						xtype: 'nestedJsonCombo',
						fieldLabel: getPersonModuleTranslation('CASTE_CATEGORY'),
						store: Ext.create('Academia.store.common.CastCategoryStore'),
						itemId: 'castCategoryCombo',
						valueField: 'id',
						displayField: 'value',
						name: 'castCategory',
						editable: false
					}]
	}
	
	]
	},
	
	{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});
