/**
 * 
 *//**
 * @author dolly.khatri
 */

Ext.define('Academia.view.feeandpayment.reports.paymentPlanReportGrid', {
	extend:'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias:'widget.paymentplanreportgrid',
	store : 'feeandpayment.reports.PaymentPlanReportStore',
	title: getCommonTranslation('PAYMENT_PLAN_REPORT'),
	cls:'centerAlignTitle',
	border: true,
	autoScroll: false,
	style: 'margin-bottom: 30px !important;',
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: true
	},
	/*features: [{
		ftype: 'summary',
		showSummaryRow:false 
	}],*/
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.reports.PaymentPlanReportStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns:[{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex:1,
		sortable:true,
		renderer:function(value){
			return '<a href=#>'+value+'</a>'
		}
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1,
		sortable:true
	},{
		header : getCommonTranslation('PAYMENT_PLAN_NAME'),
		dataIndex : 'paymentPlanName',
		flex:1,
		sortable:true,
		renderer:function(value){
			if(!isNullOrEmpty(value))
			    return '<a href=#>'+value+'</a>';
			else
				return 'N/A';
		}
	},{
		header:  getCommonTranslation('OUTSTANDING_AMOUNT'),
		dataIndex: 'outstandingAmount',
		flex:1,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(store.data.items[0].data.acadLocBaseCurrencyId)&&store.data.items[0].data.acadLocBaseCurrencyId!=0)
			{
				metaData.column.summaryType='';
			}
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
			
		}
		
	},{
		header : getCommonTranslation('PAYMENT_DETAILS'),
		dataIndex : 'paymentDetails',
		flex:1,
		sortable:true,
		renderer:function(){
			return "<a href='#'>View</a>";
		}
		
	}]

});
