/**
 * @author Priyanshi Sharma
 * 
 */
Ext.define('Academia.view.feeandpayment.voucherMode.PersonCoveredUpdateDownloadForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.personcoveredupdatedownloadform',
	//plugins : "formlabelrequired", 
	frame: false,
	method : 'POST',
	//cls:'customSearchPanel',
	standardSubmit : false,
	items : [{
		xtype:'fieldcontainer',
		items:[{
			xtype : 'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items : [{
				xtype : 'multiselectcombofield',
				width: 536,
				name : 'academyLocation',
				itemId:'academyLocationId',
				fieldLabel : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
				store:'common.AcademyLocationNameSeparated',
				allowBlank : false,
				queryParam: "qry",
				valueField : 'id',
				forceSelection : true,
				displayField : 'value',
				hideTrigger:false,
				typeAhead:true,
				triggerAction: 'all',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR')}]
		}]},

		{
			xtype:'fieldcontainer',
			layout : 'hbox',
			width: '100%',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'customcombobox',
				name: 'feePersonIdType',
				itemId:'feePersonIdTypeItemId',
				fieldLabel: getFeeAndPaymentCommonTranslation('USERS_TYPE'),
				store: 'feeandpayment.FeePersonIdType',
				valueField: 'id',
				displayField: 'value',
				allowBlank: false,
				typeAhead:true,
				forceSelection:true
			},{  
				xtype: 'customcombobox',
				name: 'feePlanType',
				itemId:'feePlanType',
				fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_TYPE'),
				store: 'feeandpayment.FeePlanTypeStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				allowBlank : false
			},{
				xtype: 'customcombobox',
				name: 'feePlan',
				itemId:'feePlan',
				disabled:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_NAME'),
				//store: 'feeandpayment.MultiSelectAcademyLocationFeePlanStore',
				store: 'feeandpayment.FeePlan',
				valueField: 'id',
				displayField: 'value',
				minChars:3,
				queryParam:'query',
				allowBlank : false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
				
			}]},
			{
				xtype:'fieldcontainer',
				layout : 'hbox',
				width: '100%',
				defaults: {
					labelAlign: 'top',
					width: 256
				},
				items: [{
					xtype : 'customcombobox',
					name : 'intakeYear',
					itemId : 'intakeYear',
					fieldLabel : getCommonTranslation('INTAKE_YEAR'),
					store : 'common.IntakeYearStore',
					valueField : 'id',
					displayField : 'value',
					allowBlank : true
				},{
					xtype: 'customcombobox',
					name: 'program',
					itemId:'program',
					fieldLabel: getFeeAndPaymentCommonTranslation('PROGRAM'),
					//store: 'common.ProgramByAcademyLocationStoreWithoutPermission',
					store: 'feeandpayment.ProgramByFeePlanStore',
					valueField: 'id',
					displayField: 'value',
					allowBlank: true,
					typeAhead:true,
					forceSelection:true,
					hideTrigger:false,
					typeAhead:true,
					triggerAction: 'all',
					minChars:3,
					queryParam:'programName',
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
				},{
					xtype: 'customcombobox',
					name: 'batch',
					itemId:'batch',
					fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
					store: 'feeandpayment.BatchByFeePlanStore',
					valueField: 'id',
					displayField: 'value',
					disabled: true,
					allowBlank: true,
					typeAhead:true,
					forceSelection:true
				}]}
			,{
				xtype:'fieldcontainer',
				layout : 'hbox',
				cls: 'customSearchPanelBtnsFieldContainerCls CustomSearchPanelBtnLeftMargin',
				items:[{
					xtype: 'button',
					text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
					itemId: 'downoladBtnId',
					hidden:false,
					ui: 'CustomBtnSubmit',
					formBind:true
				},{
					xtype: 'button',
					text: getCourseTxCommonTranslation('RESET'),
					itemId: 'resetBtn',
					//buttonAlign: 'left',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE
				}]
			}]
});
