/**
 * @author Amit Gupta
 */

Ext.define('Academia.view.filemanagement.FileUpdateStatusWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.fileupdatestatuswin',
	title:getFileManagementTranslation('UPDATE_STATUS'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'form',
		itemId:'fileupdatestatuswin',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			//width: 256
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
				
		},{
			xtype:'fieldcontainer',
			layout : {
				type : 'hbox'
			},
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'fileStatus',
				itemId:'fileStatus',
				fieldLabel: getFileManagementTranslation('STATUS'),
				store: 'filemanagement.FileStatusStore',
				valueField: 'id',
				displayField: 'value',
				allowBlank: false,
				typeAhead:true,
				editable: false,
	            disableKeyFilter: false,
				forceSelection:true
			},{
				xtype: 'datefield',
        		name: 'startDate',
        		itemId:'startDate',
        		allowBlank:true,
        		//--submitFormat:CONSTANTS.DATE_FORMAT,
        		listeners: {
        			render: function(field) {
        				return dateFormatRender(field);
        			}
        		},
    			editable:false,
    			allowBlank: false,
        		fieldLabel:getFileManagementTranslation('STATUS_CHANGE_DATE')
				
			}]
		},{
			xtype: 'textarea',
			name:'reasonUpdate',
			itemId:'reasonUpdate',
			width: 536,
			maxLength : 250,
			fieldLabel: getFileManagementTranslation('REASON_FOR_UPDATE')
			
		},{
			xtype:'fieldcontainer',
			//width:'100%',
			//cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});