/**
 * Sumit meena
 */
Ext.define('Academia.view.gradeMaster.group.GradeGroupMappingWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.gradegroupmappingwindow',
    modal: true,
    requires: ['Ext.ux.form.ItemSelector'],
    autoScroll:true,
    title: getExaminationTranslation('GROUP'),
    width: '45%',
    items: [{
        xtype: 'form',
        method: 'POST',
        autoScroll:true,
        margin: 0,
        bodyPadding: '10 10 10 10',
        layout: {
            type: 'vbox'
        },
        defaults: {
            labelAlign: 'top',
            autoScroll:true,
            width: 256
        },
        plugins:"formlabelrequired",
        standardSubmit: false,
        items: [{
        	xtype:"hidden",
        	name:"groupId"
        },{
        	xtype: 'itemselector',
            cls: 'itemSelectorCls',
            name: 'gradeGroup',
            width:500,
            imagePath: '../ux/css/images/',
            store: 'gradeMaster.GradeGroupMapping',
            displayField: 'value',
            valueField: 'id',
            allowBlank: false,
            fromTitle: getCommonTranslation('AVAILABLE'),
            toTitle: getCommonTranslation('SELECTED'),
            msgTarget: 'side',
            delimiter: null,
            buttons: ['top', 'add', 'remove', 'bottom']
        },{
            xtype: 'fieldcontainer',
            width:'95%',
            cls:'windowBtnPos',
	        items: [{
	            xtype: 'button',
	            text: getExaminationTranslation('SAVE'),
	            itemId: 'btnGradeMappingSave',
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE,
	            formBind: true
	        }, {
	            xtype: 'button',
	            text: getExaminationTranslation('CANCEL'),
	            itemId: 'btnGradeMappingCancel',
	            ui: 'CustomBtnCancel',
	            scale: CONSTANTS.BUTTONSIZE
	        }]
        }]
    }]
});