/**
 * @author Pankaj Sisodiya
 */
Ext.define('Academia.view.hostel.hostelApplicationSetup.HostelApplicationSetupGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.hostelApplicationSetupGrid',
	store: 'hostel.HostelApplicationSetup.HostelApplicationSetupGridStore',
	border: true,
	autoScroll: false,
	isGridConfigurable: true,
	enableColumnHide: false,
	title:getMegaMenuTranslation('HOSTEL_APPLICATION_SETUP'),
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	 headerFix:{
		    headerFix: true,
		    portalIdsWithStructure: {
		    'hostelApplicationSetupStructure':1
		    }},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.HostelApplicationSetup.HostelApplicationSetupGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		disabled:true,
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		disabled:true,
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		disabled:true,
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getFeeAndPaymentCommonTranslation('MOREACTIONS'),
		menu:[{
			text: getCommonTranslation('APPLY_TO'),
			itemId: 'btnApplyTo',
		}],
		listeners: { click: function() { this.showMenu(); } }
	}],
	columns: [{
		header:  getCommonTranslation('USER_TYPE'),
		dataIndex:'userType',
		flex:.1,
		sortable:true,
		renderer:function(val){
			if(val == 'STUDENT'){
				return getCommonTranslation('STUDENT');
			}else if(val == 'APPLICANT'){
				return getCommonTranslation('APPLICANT');
			}
			return getCommonTranslation("ALL");
		}
	},{
		header:  getCommonTranslation("HOSTEL_SETUP_CODE"),
		dataIndex:'setupCode',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("HOSTEL_SETUP_NAME"),
		dataIndex:'setupName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("SETUP_TYPE"),
		dataIndex:'hostelSetupType',
		flex:.1,
		sortable:true,
		renderer:function(val){
			if(val == 'HOSTEL_GENERAL_SETUP'){
				return getFeeAndPaymentCommonTranslation('GENERAL_APPLICATION');
			}else if(val == 'WAITING_LIST_SETUP'){
				return getFeeAndPaymentCommonTranslation('WAITING_LIST_APPLICATION');
			}
			return getCommonTranslation("ALL");
		}
	},{
		header:  getCommonTranslation("ACADEMIC_TERM"),
		dataIndex:'yearName',
		flex:.1,
		sortable:true,
//		renderer:function(val){
//			return val.value;
//		}
	},{
		header:  getCommonTranslation("STATUS"),
		dataIndex:'status',
		flex:.1,
		sortable:true,
		renderer:function(val){
			if(val){
				return getCommonTranslation('ACTIVE');
			}
			return getCommonTranslation('INACTIVE');
		}
	},{
		header:  getCommonTranslation("ADMIN_START_DATE"),
		dataIndex:'adminStartDate',
		flex:.1,
		hidden:true,
		sortable:true,
		renderer:function(val){
			return dateRender(val);
		}
	},{
		header:  getCommonTranslation("ADMIN_END_DATE"),
		dataIndex:'adminEndDate',
		flex:.1,
		sortable:true,
		renderer:function(val){
			return dateRender(val);
		}
	},{
		header:  getCommonTranslation("APPLICATION_START_DATE"),
		dataIndex:'applicationStartDate',
		flex:.1,
		sortable:true,
		renderer:function(val){
			return dateRender(val);
		}
	},{
		header:  getCommonTranslation("APPLICATION_END_DATE"),
		dataIndex:'applicationEndDate',
		flex:.1,
		sortable:true,
		renderer:function(val){
			return dateRender(val);
		}
	},{
		header:  getCommonTranslation("OFFER_APPLICABLE"),
		dataIndex:'offerApplicable',
		flex:.1,
		sortable:true,
		renderer:function(val){
			if(val){
				return getCommonTranslation("YES");
			}
			return getCommonTranslation("NO");
		}
	},{
		header:  getCommonTranslation("OFFER_LETTER_START_DATE"),
		dataIndex:'offerLetterStartDate',
		flex:.1,
		hidden:true,
		sortable:true,
		renderer:function(val){
			return dateRender(val);
		}
	},{
		header:  getCommonTranslation("OFFER_LETTER_END_DATE"),
		dataIndex:'offerLetterEndDate',
		flex:.1,
		hidden:true,
		sortable:true,
		renderer:function(val){
			return dateRender(val);
		}
	},{
		header:  getCommonTranslation("MAX_DAYS_ACCEPT_OFFER"),
		dataIndex:'maxDaysToAcceptOffer',
		flex:.1,
		hidden:true,
		sortable:true
	}]
});