/**
 *  @author sanjeev Ranjan
 */
var hostelLevelStore = Ext.create('Ext.data.Store', {
    fields: ['id', 'value'],
    data : [
        {"id":"Senior", "value":"Senior"},
        {"id":"Junior", "value":"Junior"},
        //...
    ]
});
var applicantionType =  Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data : [
        {"value":"WITHOUT_RESIDENCE_APPLICATION", "name":getCommonTranslation('WITHOUT_RESIDENCE_APPLICATION')},
        {"value":"WITH_RESIDENCE_APPLICATION", "name":getCommonTranslation('WITH_RESIDENCE_APPLICATION')}]
});
Ext.define('Academia.view.hostel.hostelapplication.DownloadAllocationLoaderForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.downloadallocationloaderform',
	autoScroll: false,
	frame: false,
	//cls:'customSearchPanel',
	standardSubmit: false,
	
	items: [
		{
			xtype: 'radiogroup',
			itemId:'eventQuestionGroupId',
			name: 'eventQuestion',
			labelAlign:'top',			
			columns: 3,
			vertical: true,
			items : [ {
				boxLabel: getCommonTranslation('APPLICANT'),
				name: 'studentHostel',
				inputValue: 'APPLICANT',
				checked: true
			},{
				boxLabel: getCommonTranslation('STUDENT'),
				name: 'studentHostel',
				inputValue: 'STUDENT'

			}]
		    },
		{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
	    	xtype: 'customcombobox',
			name: 'type',
			itemId:'typeItemId',
			allowBlank:false,
			store: applicantionType,
        	valueField: 'value',
        	displayField: 'name', 
        	editable: false,
        	querymode: 'local',
			fieldLabel: getCommonTranslation('TYPE'),
			typeAhead:false,
			forceSelection:true,
			hidden:true		
	    },{
         	xtype: 'customcombobox',
            name: 'applicantType',
            itemId:'applicantType',
            fieldLabel: getCommonTranslation('APPLICATION_TYPE'),
            store: 'hostel.hostelapplication.HostelApplicationTypeStore',
            displayField:'value',
            valueField:'id',
            forceSelection:true,
	        editable: false,
	        allowBlank:false,
	        queryParam:'qry',
			hideTrigger:false,
			triggerAction: 'all',
			autoloadStore: false,
		},
		{
			xtype: 'customcombobox',
			name: 'applicationStatus',
			itemId:'applicationStatusId',
			fieldLabel: getCommonTranslation('ACTIVITY'),
			store: Ext.create('Academia.store.hostel.hostelapplication.ApplicationStatusStore'),
			valueField: 'id',
			displayField: 'value',
			editable: false,
			allowBlank:false,
			forceSelection:true
		},
		{			
			xtype : 'customcombobox',
			cls:'commonAutoHeightMultiselectField',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
			autoloadStore: false,
			name : 'year',
			itemId : 'YearId',      	   
			displayField : 'value',
			valueField : 'id',
			forceSelection : true,
			allowBlank : false,
			hidden : false,
			queryParam:'qry',
			editable: false,
			hideTrigger:false,
			triggerAction: 'all',
			autoloadStore: false,
			store:Ext.create('Academia.store.common.BulkStatusUpdateYearStore'),
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [
		]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		}
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
         	xtype: 'customcombobox',
            name: 'applicantYear',
            itemId:'applicantYear',
            fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
            store: Ext.create('Academia.store.common.BulkStatusUpdateYearStore'),
            displayField:'value',
            valueField:'id',
            forceSelection:true,
	        editable: false,
	        allowBlank:false,
	        queryParam:'qry',
			hideTrigger:false,
			triggerAction: 'all',
			autoloadStore: false,
			hidden : true,
		},
			{
				xtype: 'customcombobox',
				name: 'locationId',
				itemId: 'locationItemId',
				fieldLabel: getCommonTranslation('LOCATION'),
				store: 'hostel.managehostel.hostel.LocationCodeName',
				displayField: 'value',
				valueField: 'id',
				editable: false,
				forceSelection:true
			},
			{
				xtype: 'customcombobox',
				name: 'waitingList',
				itemId:'waitingList',
				fieldLabel: getCommonTranslation('HOSTEL_CONFIGURATION_ID_NAME'),
				store:Ext.create('Academia.store.hostel.hostelapplication.WaitingListForApplicantStore'),
				displayField:'value',
	            valueField:'id',
				editable: false,
				
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'listIdName',
				itemId:'listIdNameId',
				fieldLabel: getCommonTranslation('HOSTEL_CONFIGURATION_ID_NAME'),
				store:Ext.create('Academia.view.hostel.hostelapplication.WaitingListNameStore'),
				displayField:'value',
	            valueField:'id',
				editable: false,
				forceSelection:true,
				hidden:true,
//				disabled:true,
			},{
				xtype:'customcombobox',
				fieldLabel:getCommonTranslation('HOSTEL_LEVEL'),
				store:hostelLevelStore,
				displayField:'value',
				valueField:'id',			
				itemId:'hostelLevelItemId',
				name:'hostelLevelName',
				width: 256,
				editable: false,
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.maxWidth = picker.up('combobox').getSize().width;
						}
					}
				}
			}]
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls CustomSearchPanelBtnLeftMargin',
		layout: 'hbox',
		items : [ {
          	 xtype: 'button',
        	 text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
             itemId: 'searchButtonId',
             formBind : true,
             ui: 'CustomBtnSubmit'
        }, {
			xtype: 'button',
			text : getCommonTranslation('RESET'),
			itemId : 'resetButtonId',
			//buttonAlign : 'left',
			ui : 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		} ]
	}]
});
