/**
 *  @author Suraj Chouhan
 */
Ext.define('Academia.view.hostel.hostelapplication.HostelApplicationsListGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.hostelapplicationslistgrid',
	store : 'hostel.hostelapplication.HostelApplicationsListGridStore',
	title: getCommonTranslation('RESIDENCE_APPLICATIONS'),
	border: true,
	reserveScrollbar:true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	//renderTo: Ext.getBody(),
    /*selModel: {
        selType: 'checkboxmodel'
    },*/
	selType:'checkboxmodel',
    selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
    headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'hostelapplicationsstructure':1
		}
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.hostelapplication.HostelApplicationsListGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAllotRoom',
		text: getHostelTranslation('ALLOT_ROOM')
	},{
		xtype: 'button',
		itemId: 'btnRejectApplication',
		text: getHostelTranslation('CANCEL_APPLICATION')
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),
		menu:[{
			text: getCommonTranslation('ALLOCATE_HOSTEL'),
			itemId: 'allocateResidence',
		},{
			text:getCommonTranslation('CANCEL_HOSTEL_ALLOCATION'),
			itemId:'unallocateResidence'
		}],
		listeners: { click: function() { this.showMenu(); } }
	}],
	columns: [{
		header : getCommonTranslation('APPLICATION_TYPE'),
		dataIndex : 'applicationType',
		flex:1,
		renderer:function(value){
			if(value == 'WAITING_LIST_SETUP'){
				return  getFeeAndPaymentCommonTranslation('WAITING_LIST_APPLICATION');
			}else if(value == 'HOSTEL_GENERAL_SETUP'){
				return getFeeAndPaymentCommonTranslation('GENERAL_APPLICATION');
			}else {
				return '';
			}
		}
	},{
		header : getCommonTranslation('APPLICATION_ID'),
		dataIndex : 'applicationId',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getCommonTranslation('ADMISSION_ID'),
		dataIndex : 'admissionId',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'program',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batch',
		flex:1
	},
	{
		header : getCommonTranslation('SEAT_TYPE'),
		dataIndex : 'seatType',
		flex:1
	},
	{
		header : getCommonTranslation('HOSTEL_CONFIGURATION_ID_NAME'),
		dataIndex : 'waitingListIdName',
		flex:1
	},
	{
		header : getCommonTranslation('APPLIED_HOSTEL_CODE_NAME'), 
		dataIndex : 'hostelCodeName',
		flex:1,
		renderer:function(value, meta, record){
          if(!isNullOrEmpty(record.data.hosteCode)) {
              return record.data.hosteCode + ' '+record.data.hosteName;
          } 
		}
	},
	{
		header : getCommonTranslation('APPLICATION_STATUS'),
		dataIndex : 'applicationStatus',
		flex:1,
		renderer:function(value){
			if(value == 'SUBMITTED' || value == 'Submitted'){
                return  getFeeAndPaymentCommonTranslation('SUBMITTED');
            }else if(value == 'REVOKED' || value == 'Revoked'){
                return  getFeeAndPaymentCommonTranslation('REVOKED');
            }else if(value == 'CANCELLED' || value == 'Cancelled'){
                return  getFeeAndPaymentCommonTranslation('CANCELLED');
            }else if(value == 'ALLOCATED' || value == 'Allocated'){
                return  getFeeAndPaymentCommonTranslation('ALLOCATED');
            }else if(value == 'UNALLOCATED' || value == 'Unallocated'){
                return  getFeeAndPaymentCommonTranslation('UNALLOCATED');
            }else if(value == 'ALLOTTED' || value == 'Allotted'){
                return  getHostelTranslation('ALLOTTED');
            }else if(value == 'CHECKED_IN' || value == 'Checked In'){
                return getHostelTranslation('CHECKED_IN');
            }else if(value == 'CHECKED_OUT' || value == 'Checked Out'){
                return getHostelTranslation('CHECKED_OUT');
            }else if(value == 'CANCEL_CHECK_IN' || value == 'Cancel Check-In'){
                return getHostelTranslation('CANCEL_CHECK_IN');
            }else {
            	return '';
            }
		}
	},
	{
		header : getCommonTranslation('APPLICATION_DATE'),
		dataIndex : 'applicationDate',
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
		
	},
	{
		header : getCommonTranslation('ALLOCATED_HOSTEL'),
		dataIndex : 'allocatedHostel',
		flex:1
	},
	{
		header : getCommonTranslation('ACADEMIC_TERM'),
		dataIndex : 'hostelApplicationYear',
		flex:1
	},
	{
		header : getCommonTranslation('RESTRICTION_TYPE'),
		dataIndex : 'restrictionType',
		flex:1
	},
	{
		header : getCommonTranslation('WARDEN'),
		dataIndex : 'warden',
		flex:1
	},
	{
		header : getCommonTranslation('HOSTEL_CATEGORY'),
		dataIndex : 'hostelCategory',
		flex:1,
		renderer:function(value) {
			if(value == 'CATERED'){
				return  'Catered';
			}else if(value == 'SELF_CATERED'){
				 return 'Self-catered';	
			}else {
				return '';
			}
		}
	},
	{
		header : getCommonTranslation('CLUSTER_CODE'),
		dataIndex : 'clusterCode',
		flex:1
	},
	{
		header : getCommonTranslation('HOSTEL_TYPE'),
		dataIndex : 'hostelType',
		flex:1
	},
	{
		header : getCommonTranslation('HOSTEL_LEVEL'),
		dataIndex : 'hostelLevel',
		flex:1
	},
	{
		header : getCommonTranslation('CANCELLATION_REASON'),
		dataIndex : 'cancellationReason',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('CANCELLATION_BY'),
		dataIndex : 'cancellationBy',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('WANT_TO_REALLOCATE_SAME_HOSTEL'),
		dataIndex : 'reallocateSameResidence',
		flex:1,
		hidden:true,
		renderer:function(value) {
			if(value == true){
				return  getFeeAndPaymentCommonTranslation('YES');
			}else if(value == false){
				 return getFeeAndPaymentCommonTranslation('NO');	
			}else {
				return '';
			}
		}
		
	}],
});