/**
 *  @author Pankaj Sisodiya
 */
Ext.define('Academia.view.hostel.hostelapplication.HostelIssueOfferLatter',{
	extend: 'Ext.window.Window',
	alias: 'widget.hostelIssueOfferLatter',
	title:getHostelTranslation('ISSUE_OFFER_LETTER'),
	frame: true,
	autoScroll:false,
	modal:true, 
	height: 280,
	width: '55%',
	items: [{
        xtype: 'form',
        plugins : "formlabelrequired",
        items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 180
            },
            items: [{
            	xtype: 'displayfield',
            	fieldLabel:getAdmissionTranslation('APPLICANT_ID_NAME'),
            	itemId: 'applicationId'
    		}, {

    			xtype: 'displayfield',
                fieldLabel: getCommonTranslation('APPLICATION_TYPE'),
                itemId: 'applicationType'
          }, {

  			xtype: 'displayfield',
              fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
              itemId: 'academicTerm'
        },{
			xtype: 'datefield',
			name: 'offerExpiryDate',
			itemId:'offerExpiryDate',
			allowBlank:false,
			fieldLabel: getHostelTranslation('OFFER_EXPIRY_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]
        },{

            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 245
            },
            items: [{
            	xtype: 'customcombobox',
    			name: 'locationId',
    			itemId: 'location',
    			fieldLabel: getCommonTranslation('LOCATION'),
    			store: 'hostel.hostelapplication.HostelApplicationLocationStore',
    			displayField: 'name',
    			valueField: 'id',
    			allowBlank:false,
    			editable: false,
    			forceSelection:true
    		}, {

    			xtype: 'customcombobox',
    			name: 'depositCategory',
    			itemId:'depositCategory',
    			fieldLabel: getHostelTranslation('DEPOSIT_CATEGORY'),
    			store: 'hostel.hostelapplication.HostelApplicationIssueDepositStore',
    			valueField: 'id',
    			displayField: 'value',
    			editable: false,
    			allowBlank:false,
    			forceSelection:true
          }, {

        	  xtype: 'customcombobox',
  			name: 'reservationCategory',
  			itemId:'reservationCategory',
  			fieldLabel: getHostelTranslation('RESERVATION_CATEGORY'),
  			store: 'hostel.hostelapplication.HostelApplicationReservationCategoryStore',
  			valueField: 'id',
  			displayField: 'value',
  			editable: false,
  			allowBlank:false,
  			forceSelection:true
        }]
        
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            style: {
                marginTop: '17px',
                marginLeft: '-2px'
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SUBMIT'),
                itemId: 'offerLatterSubmitBtn',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                buttonAlign: 'right',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]     
});