/**
 * @author sohan chouhan
 * 
 */
Ext.define('Academia.view.hostel.hostelapplication.HostelRejectApplicationWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.hostelrejectapplicationwindow',
    modal: true,
    resizable: false,
    title: getCommonTranslation('REJECT_HOSTEL_APPLICATION'), 	
    margin: 0,
    items: [{
        xtype: 'form',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [
        	{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            items: [{
            	itemId: 'rejectionDate',
                fieldLabel: getCommonTranslation('REJECTION_DATE'),
                xtype: 'datefield',
                name: 'rejectionDate',
                labelAlign: 'top',
                width: 256,
                allowBlank: false,
                listeners: {
    				render: function(obj) {
    					obj = dateFormatRender(obj);						
    					obj.setValue(new Date());
    				}
    			}
            },{
            	xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('REJECTED_BY'),
                itemId: 'rejectedBy',
                name : 'rejectionByField',
                minChars:3,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                labelAlign: 'top',
                //allowBlank: false
                store:Ext.create('Academia.store.criteriabuilder.userquicksearch.QuickSearchName'),
    			displayField: 'value',
    			valueField: 'id',
    			width: 256,
    			queryParam:'qry',
    			typeAhead : true,
    			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    			enableKeyEvents  : 'true',
    			forceSelection:true,
    			hideTrigger:false,
    			queryMode: 'remote',
    			triggerAction: '',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}'  +
    					'</div>';
    				}
    			}
    		
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            items: [{
        		xtype: 'fieldcontainer',
        		layout: {
        			type: 'hbox'
        		},
        		defaults: {
        			width: 536,
        			labelAlign: 'top'
        		},
        		items:[{
        			xtype: 'textarea',
        			itemId:'rejectionRemark',
        			name:'rejectionRemark',
        			width: 536,
        			maxLength : 255,
        			fieldLabel: getExaminationTranslation('REMARKS')
        		}]
        	}]
        },{
            xtype: 'fieldcontainer',
            width: '100%',            
            items: [{
                xtype: 'button',
                itemId: 'btnSaveRejectApplication',
                text: getCommonTranslation('SAVE'), //Submit
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelRejectApplication',
                text: getCommonTranslation('CANCEL'), //Cancel
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]

    }]
});