/**
 * @author Deepak Sharma
 * 
 *  
 */
Ext.define('Academia.view.hostel.hostelattendance.UpdateAttendanceFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.updateattendanceformwindow',
    modal: true,
    resizable: false,
    title: getCommonTranslation('UPDATE_ATTENDANCE'),
    margin: 0,
    items: [{
        xtype: 'form',
        itemId: 'updateAttendanceForm',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
            xtype: 'hidden',
            name: 'hostelCodeName'
        }, {
            xtype: 'hidden',
            name: 'buildingCodeName'
        }, {
            xtype: 'hidden',
            name: 'floorCodeNo'
        }, {
            xtype: 'hidden',
            name: 'studentName'
        }, {
            xtype: 'hidden',
            name: 'attendanceStatus'
        }, {
            xtype: 'hidden',
            name: 'fromDate'
        }, {
            xtype: 'hidden',
            name: 'toDate'
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
				xtype:'displayfield',
				name:'winHostelName',
				itemId:'winHostelNameItemId',
				fieldLabel: 'Hostel Name',
				value: '<span></span>'
			},{
				xtype:'displayfield',
				name:'winRecSelected',
				itemId:'winRecSelectedItemId',
				fieldLabel: 'No. of Records Selected',
				value: '<span>0</span>'
			}]
        }, {
        	xtype: 'fieldcontainer',
        	layout: {
        		type: 'hbox'
        	},
        	defaults: {
        		labelAlign: 'top',
        		width: 256
        	},
        	items: [{
        		xtype: 'customcombobox',
        		name:'winAttendanceStatus',
        		itemId:'winAttendanceStatusItemId',
        		store:'hostel.hostelattendance.HostelAttendanceStatus',
        		valueField : 'id',
        		displayField : 'value',
        		fieldLabel: getHostelTranslation('ATTENDANCE_STATUS'),
        		editable: false
        	}]
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 536
            },
            items: [{
            	xtype: 'textareafield',
            	name: 'winRemarks',
            	itemId:'winRemarksItemId',
            	maxLength : 255,
            	fieldLabel: getCommonTranslation('Remarks')
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',

            items: [{
                xtype: 'button',
                itemId: 'winBtnSaveUpdateAttendanceForm',
                text: getCommonTranslation('SAVE'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
				xtype: 'button',
				text : getCommonTranslation('RESET'),
				itemId : 'winResetButtonId',
				buttonAlign : 'left',
				ui : 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
        }]
    }]
});
