/**
 *  @author Dharmendra.p
 */
Ext.define('Academia.view.hostel.managerestrictiontype.ManageRestrictionTypeGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.managerestrictiontypegrid',
	store : 'hostel.managerestrictiontype.ManageRestrictionTypeGrid',
	title: getHostelTranslation('LIST_OF_RESTRICTION_TYPES'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'managerestrictiontypestructure':1
		}
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.managerestrictiontype.ManageRestrictionTypeGrid',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getHostelTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getHostelTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getHostelTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getHostelTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getHostelTranslation('RESTRICTION_TYPE'),
		dataIndex : 'restrictionType',
		flex:1
	},{
		header : getHostelTranslation('GENDER'),
		dataIndex : 'gender',
		flex:1,
		renderer:function(value,meta,record){
			if (!isNullOrEmpty(value)) {
			return  record.raw.gender.value
;
			}else {
					return '-';
			}		
		}
	},{
		header : getHostelTranslation('USER_TYPE'),
		dataIndex : 'usersGroup',
		flex:1/*,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				return value.value;
				console.log('value',value);
			}
		}*/
	},{
		header : getHostelTranslation('STATUS'),
		dataIndex : 'status',
		flex : 1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'ACTIVE' || value == 'Active'){
					return '<span style="color:green;">' + getHostelTranslation('ACTIVE') + '</span>';
				}else{
					return '<span style="color:red;">' + getHostelTranslation('IN_ACTIVE') + '</span>';
				} 
			}
		}
	}]
});