/**
 *  @author Dharmendra.p
 */
Ext.define('Academia.view.hostel.manageroomtype.ManageRoomTypeGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.manageroomtypegrid',
	store : 'hostel.manageroomtype.ManageRoomTypeGrid',
	title: getHostelTranslation('LIST_OF_ROOM_TYPES'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'manageroomtypestructure':1
		}
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.manageroomtype.ManageRoomTypeGrid',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getHostelTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getHostelTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getHostelTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getHostelTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
        xtype: 'button',
        text : getHostelTranslation('COPY_SCHEDULE_TO'),
        itemId: 'copyScheduleToItemId',
        disabled: true

		}
	],
	columns: [{
		header : getHostelTranslation('ROOM_TYPE'),
		dataIndex : 'roomType',
		flex:1
	},{
		header : getHostelTranslation('FEE_PLAN'),
		dataIndex : 'feePlanName',
		flex:1
	},{
		header : getHostelTranslation('FEE_PLAN_RULE'),
		dataIndex : 'feePlanRule',
		flex:1
	},{
		header : getHostelTranslation('STATUS'),
		dataIndex : 'status',
		flex : 1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'ACTIVE' || value == 'Active'){
					return '<span style="color:green;">' + getHostelTranslation('ACTIVE') + '</span>';
				}else{
					return '<span style="color:red;">' + getHostelTranslation('IN_ACTIVE') + '</span>';
				} 
			}
		}
	}]
});