/**
 * priyanshi sharma

 */

Ext.define('Academia.view.hostel.manageroomtype.TariffPlanDetailsEditWindow',{
	extend: 'Ext.window.Window',
	alias : 'widget.tariffplandetailseditwindow',
	title : getHostelTranslation('TARIFF_PLAN_DETAILS'),
	frame: true,
	autoScroll:true,
	modal:true, 
	method: 'POST',
	height: '50%',
	width: '50%',
	items : [{
		xtype: 'form',
		standardSubmit : false,
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top'
		},
		items: [{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			//width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'datefield',
			name: 'fromDate',
			itemId:'fromDateId',
			vtype: 'daterange',
			endDateField:'toDateId',
			allowBlank:false,
			fieldLabel : getHostelTranslation('FROM_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},{
			xtype: 'datefield',
			name: 'toDate',
			itemId:'toDateId',
			vtype: 'daterange',
			startDateField:'fromDateId',
			style:{
				marginLeft:'14px !important'
			},
			allowBlank:false,
			fieldLabel : getHostelTranslation('TO_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		layout:{
			type:'vbox',
		},
		items:[{
				xtype:'fieldcontainer',
				itemId:'feeHeadContainerId',
				items:[{
					xtype : 'fieldcontainer',
					width: '100%',
					layout : 'hbox',
					cls:'feeHeadsContainer',
					defaults: {
						labelAlign: 'top',
					//	width: 256,
					},
					items : [{
						xtype : 'customcombobox',
						name : 'feeHead',	
						itemId:'feeHead',
						allowBlank:false,
						store: 'hostel.manageroomtype.FeeHeadsStore',
						displayField: 'feeHeadName',
						valueField: 'id',		
						fieldLabel:getHostelTranslation('FEE_HEAD'),
						listeners: {
							change: function(combo, newValue, oldValue, eOpts) {
								if(combo.findRecordByValue(newValue)) {
									this.up('form').down('textfield#amount').setValue(combo.findRecordByValue(newValue).get('feeAmount'));
									this.up('form').down('hidden#feeStageHeadConfigId').setValue(combo.findRecordByValue(newValue).get('feeStageHeadConfigId'));
								}
							}
						}
					},{
						xtype : 'textfield',
						allowBlank:false,
						name : 'amount',	
						itemId:'amount',
						style:{
							marginLeft:'14px !important'
						},
						fieldLabel:getHostelTranslation('AMOUNT'),
					},{
						xtype: 'hidden',
						name: 'feeStageHeadConfigurationId',
						itemId: 'feeStageHeadConfigId'
					},{
						xtype: 'button',
						itemId: 'addMoreRowBtn',
						cls: 'CustomBodyBtnSettings',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getHostelTranslation('ADD'),
						style:{
							marginTop:'30px',
							marginLeft:'8px !important'
						}
					}]
				}]
			}]
	},{
		xtype:'fieldcontainer',
		width:'100%',
		defaults: {
			labelAlign: 'top',
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'numberfield',
			name : 'defaultTariffAmount',	
			itemId:'defaultTariffAmount',
			readOnly:true,
			fieldLabel:getHostelTranslation('TOTAL_DEFAULT_TARIFF_AMOUNT'),
		}]
	},{
		xtype:'fieldcontainer',
		width:'100%',
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'button',
			text : getHostelTranslation('SAVE'),
			itemId : 'saveBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype : 'button',
			text : getHostelTranslation('CANCEL'),
			itemId : 'cancelBtn',
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		}]
	}]
	}]
});