/**
 *  @author Sohan Chouhan

 */
Ext.define('Academia.view.hostel.reports.hosteldetailreport.HostelDetailsReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.hosteldetailsreportgrid',
	store : 'hostel.reports.HostelDetailReportStore',
	isGridConfigurable: true,
	enableColumnHide: false,
	title: getHostelTranslation('HOSTEL_DETAILS_REPORT'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'hosteldetailreportstructure':1
		}
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.reports.HostelDetailReportStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments); 
	},
	columns: [{
		header : getHostelTranslation('STUDENT_NUMBER'),
		dataIndex : 'studentCode',
		flex:1
	},{
		header : getCommonTranslation('ADMISSION_ID'),
		dataIndex : 'admissionId',
		flex:1
	},{
		header : getCommonTranslation('SALUTATION'),
		dataIndex : 'salutation',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex:1
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex:1,
		hidden:true
	},
	{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex:1,
		hidden:true
	},{
		header : getHostelTranslation('BUILDING_CODE_NAME'),
		dataIndex : 'buildingCode',
		flex:1,
		renderer:function(value,record){
			var buildingCodeName='';
			if(!isNullOrEmpty(record.record.get("buildingCode") )){
				var buildingCode = record.record.get("buildingCode");
				var buildingName = record.record.get("buildingName");
				buildingCodeName = buildingCode+ '/' +buildingName;
			}
			return  buildingCodeName;			 
		}
	},{
		header : getHostelTranslation('ROOM_NO'),
		dataIndex : 'roomNo',
		flex:1
	},{
		header : getHostelTranslation('ACADEMIC_BOLCK_CODE'),
		dataIndex : 'academiTerm',
		flex:1
	},
	{
		header : getHostelTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex:1
	},
	{
		header : getHostelTranslation('NO_OF_DAYS'),
		dataIndex : 'totalNoOfDays',
		flex:1
	},
	{
		header : getHostelTranslation('NETWORK_DAYS'),
		dataIndex : 'totalNoOfWorkingDays',
		flex:1
	},{
		header : getHostelTranslation('CHECKED_IN_DATE'),
		dataIndex : 'checkInDate',
		flex:1,
		hidden:true,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getHostelTranslation('CHECKED_OUT_DATE'),
		dataIndex : 'checkOutDate',
		flex:1,
		hidden:true,
		renderer: function(date) {
			return dateRender(date);
		}
	}]
});