Ext.define('Academia.view.hostel.reports.hostelfeereports.HostelBillDetails', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.hostelbilldetails',
	store :'hostel.reports.hostelfeereport.HostelBillDetails',
	title: getFeeAndPaymentCommonTranslation('BILLS'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.reports.hostelfeereport.HostelBillDetails',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('BILL_ID'),
		dataIndex : 'billNo',
		flex:1,
	},{
		header : getFeeAndPaymentCommonTranslation('BILL_DATE'),
		dataIndex : 'billDate',
		renderer:function(val){		
			return dateRender(val);
		},
		flex:1,
	},{
		header : getFeeAndPaymentCommonTranslation('FEE_PLAN'),
		dataIndex : 'feePlanName',
		flex:1,
	},{
		header : getFeeAndPaymentCommonTranslation('TOTAL_AMOUNT'),
		dataIndex : 'billFeeAmount',
		flex:1,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.raw.currencyId)){
				return currencyRenderer(value,record.raw.currencyId);
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('DISCOUNT_AMOUNT'),
		dataIndex : 'billDiscountAmount',
		flex:1,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.raw.currencyId)){
				return currencyRenderer(value,record.raw.currencyId);
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('ALL_SETTLEMENT'),
		dataIndex : 'billAdjustedAmount',
		flex:1,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.raw.currencyId)){
				return currencyRenderer(value,record.raw.currencyId);
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('CONCESSION_AMOUNT'),
		dataIndex : 'billConcessionAmount',
		flex:1,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.raw.currencyId)){
				return currencyRenderer(value,record.raw.currencyId);
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('BILLABLE_AMOUNT'),
		dataIndex : 'billBillableAmount',
		flex:1,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.raw.currencyId)){
				return currencyRenderer(value,record.raw.currencyId);
			}
		}
	}]
});