Ext.define('Academia.view.hostel.reports.hostelfeereports.HostelFeeReportSearch', {
    extend: 'Ext.form.Panel',
    alias: 'widget.hostelfeereportsearch',
    autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	standardSubmit: false,
	plugins : "formlabelrequired",
	items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [ {
            xtype: 'multiselectcombofield',
            fieldLabel: getHostelTranslation('ACADEMY_LOCATION'),
            width: 536,
            store : 'user.UserAcademyLocationStore',
            cls:'multiBrandCampusCls',
            editable : false,
            autoloadStore: false,
            name: 'academyLocation',
            itemId: 'academyLocation',
            valueField: 'id',
            displayField: 'value',
            typeAhead: true,
            forceSelection: true,
            allowBlank:false,
            triggerAction: 'all',
            minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR')
        }]
    },{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype: 'customcombobox',
			name:'transactionType',
			itemId:'transactionType',
			store:'hostel.reports.hostelfeereport.TransactionType',
			fieldLabel: getHostelTranslation('TRANSACTION_TYPE'),
			valueField: 'id',
			displayField: 'value',
			allowBlank:false,
			editable:false
		}, {
			xtype: 'customcombobox',
			name: 'studentName',
			itemId: 'studentName',
			width: 536,
			fieldLabel: getHostelTranslation('OCCUPANT_NAME'),
			store: 'hostel.roomallocation.UserSmartSearchForOccupant',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		}]
	},{ 
		xtype : 'fieldcontainer',
		width: '100%',
		layout:'hbox',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'datefield',
			fieldLabel : getProgramandcourseTranslation('FROM_DATE'),
			name : 'fromDate',
			itemId:'fromDate',
			endDateField : 'toDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
			vtype : 'daterange'
		},{
			xtype : 'datefield',
			fieldLabel :getProgramandcourseTranslation('TO_DATE'),
			name : 'toDate',
			itemId : 'toDate',
			startDateField : 'fromDate',
			listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
			vtype : 'daterange'
		}]
	},{
			xtype: 'fieldset',
			collapsible : true,
			collapsed: true,
			title: getHostelTranslation('MORE_FILTERS'),
			titleCollapse: true,
			width:'100%',
			style: {
            	 marginTop: '40px!important'
                     },
			items:[{
	            xtype: 'fieldcontainer',
	            layout: 'hbox',
	            defaults: {
	                labelAlign: 'top',
	                width: 256
	            },
	            items: [{
	    			xtype: 'customcombobox',
	    			name: 'billNo',
	    			itemId: 'billNo',
//	    			width: 536,
	    			fieldLabel: getHostelTranslation('BILL_NO'),
	    			store: 'hostel.reports.hostelfeereport.BillNumberByAcademyLocation',
	    			valueField: 'id',
	    			displayField: 'value',
	    			queryParam:'billNo',
	    			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	    			enableKeyEvents  : 'true',
	    			minChars:3,
	    			typeAhead:false,
	    			forceSelection:true,
	    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    			triggerAction: '',
	    			hideTrigger:false,
	    			listConfig: {
	    				loadingText: getCommonTranslation('SEARCHING'),
	    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    				getInnerTpl: function() {
	    					return '<div class="search-item">' +'{value}' +'</div>';
	    				},
	    				listeners: {
	    					beforeshow: function(picker) {
	    						picker.minWidth = picker.up('combobox').getSize().width;
	    					}
	    				}
	    			}
	    		},{
	    			xtype: 'customcombobox',
	    			name: 'receiptNo',
	    			itemId: 'receiptNo',
//	    			width: 536,
	    			fieldLabel: getHostelTranslation('RECEIPT_NO'),
	    			store: 'hostel.reports.hostelfeereport.ReceiptNoByAcademyLocation',
	    			valueField: 'value',
	    			displayField: 'value',
	    			queryParam:'receiptNo',
	    			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	    			enableKeyEvents  : 'true',
	    			minChars:3,
	    			hidden:true,
	    			typeAhead:false,
	    			forceSelection:true,
	    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    			triggerAction: '',
	    			hideTrigger:false,
	    			listConfig: {
	    				loadingText: getCommonTranslation('SEARCHING'),
	    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    				getInnerTpl: function() {
	    					return '<div class="search-item">' +'{value}' +'</div>';
	    				},
	    				listeners: {
	    					beforeshow: function(picker) {
	    						picker.minWidth = picker.up('combobox').getSize().width;
	    					}
	    				}
	    			}
	            },{
	    			xtype: 'customcombobox',
	    			name: 'paymentVoucherNo',
	    			itemId: 'paymentVoucherNo',
//	    			width: 536,
	    			fieldLabel: getHostelTranslation('PAYMENT_VOUCHER_NO'),
	    			store: 'hostel.reports.hostelfeereport.PaymentVoucherNoByAcademyLocation',
//	    			valueField: 'id',
	    			valueField: 'value',
	    			displayField: 'value',
	    			queryParam:'receiptNo',
	    			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	    			enableKeyEvents  : 'true',
	    			minChars:3,
	    			hidden:true,
	    			typeAhead:false,
	    			forceSelection:true,
	    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    			triggerAction: '',
	    			hideTrigger:false,
	    			listConfig: {
	    				loadingText: getCommonTranslation('SEARCHING'),
	    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    				getInnerTpl: function() {
	    					return '<div class="search-item">' +'{value}' +'</div>';
	    				},
	    				listeners: {
	    					beforeshow: function(picker) {
	    						picker.minWidth = picker.up('combobox').getSize().width;
	    					}
	    				}
	    			}
	            },{
	    			xtype: 'customcombobox',
	    			name:'feePlanName',
	    			itemId:'feePlanName',
	    			store:'hostel.reports.hostelfeereport.FeePlanByAcademyLocation',
	    			fieldLabel: getHostelTranslation('FEE_PLAN_NAME'),
	    			valueField: 'id',
	    			displayField: 'value',
	    			editable:false
	    		},{
					xtype: 'customcombobox',
					itemId: 'paymentMode',
					name: 'paymentMode',
					fieldLabel: getHostelTranslation('PAYMENT_MODE'),
					store: 'feeandpayment.FeePaymentMode',
					valueField: 'id',
					displayField: 'value',
					hidden:true,
				    forceSelection:true
				}]
	        },{
	            xtype: 'fieldcontainer',
	            layout: 'hbox',
	            defaults: {
	                labelAlign: 'top',
	                width: 256
	            },
	            items: [{
	                xtype: 'customcombobox',
	                fieldLabel: getHostelTranslation('HOSTEL_NAME'),
	                store : 'hostel.managehostel.hostel.ManageHostelCodeName',
	                editable : false,
	                name: 'hostelCodeName',
	                itemId: 'hostelCodeName',
	                valueField: 'id',
	                displayField: 'value'
	            },{
	                xtype: 'customcombobox',
	                fieldLabel: getHostelTranslation('BUILDING_NAME'),
	                store : 'hostel.managehostel.building.ManageBuildingCodeName',
	                editable : false,
	                name: 'buildingCodeName',
	                itemId: 'buildingCodeName',
	                valueField: 'id',
	                displayField: 'value'
	            },{
	                xtype: 'customcombobox',
	                name: 'floorCodeNo',
	                itemId: 'floorCodeNo',
	                store:'hostel.managehostel.floor.ManageFloorCodeName',
	                fieldLabel: getHostelTranslation('FLOOR_NO'),
	                editable: false,
	                displayField: 'value',
	                valueField: 'id',
	            }]
	        },{
	            xtype: 'fieldcontainer',
	            layout: 'hbox',
	            defaults: {
	                labelAlign: 'top',
	                width: 256
	            },
	            items: [{
		            xtype: 'checkboxfield',
		            width: 'auto',
		            labelAlign: 'right',
		            itemId:'whetherGroupByStudentFees',
		            boxLabel: getHostelTranslation('WHETHER_GROUP_BY_STUDENT'),
		            name: 'whetherGroupByStudentFees',
		            inputValue : true
		        }]
	        }]          
        }, {
        	xtype : 'fieldcontainer',
			width : 'auto',
			cls: 'customSearchPanelBtnsFieldContainerCls',
    		layout : {
    			type : 'hbox'
    		},
			items : [ {
				xtype : 'button',
				text : getCommonTranslation('SEARCH'),
				itemId : 'searchBtn',
				//buttonAlign : 'left',
				ui : 'CustomBtnSubmit',
				formBind:true,
				scale: CONSTANTS.BUTTONSIZE
			}, {
				xtype: 'button',
				text : getCommonTranslation('RESET'),
				itemId : 'resetButton',
				//buttonAlign : 'left',
				ui : 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			} ]
		}]
});
