/**
 *  @author Dharmendra.p
 */
Ext.define('Academia.view.hostel.reports.manageallocationreport.ManageAllocationGridReport', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.manageallocationgridreport',
	store :'hostel.reports.ManageAllocationReportStore',
	title: getHostelTranslation('LIST_OF_ROOMS'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	/*features: [{
		ftype: 'summary',
		showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
	}],*/
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.reports.ManageAllocationReportStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},
	columns: [{
		text : getHostelTranslation('OCCUPANTID'),
		dataIndex : 'userCode',
		hidden:true,
		sortable : true,
		flex:1
	},{
		header : getHostelTranslation('OCCUPANT'),
		dataIndex : 'userName',
		flex:1,
		/*renderer:function(value){
			if(!isNullOrEmpty(value)){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}*/
		/*summaryRenderer: function(value, summaryData, dataIndex) {
			return getFeeAndPaymentCommonTranslation('TOTAL');
		}*/
	},{
		text : getHostelTranslation('CITY'),
		dataIndex : 'city',
		hidden:true,
		flex:1		
	},{
		text : getHostelTranslation('PROGRAM'),
		dataIndex : 'programName',
		hidden:true,
		flex:1		
	},{
		text : getHostelTranslation('BATCH'),
		dataIndex : 'batchName',
		hidden:true,
		flex:1
	},{
    	header: getHostelTranslation('GENDER'),
    	dataIndex: 'gender',
    	hidden: true,
    	flex: 1,
    	renderer: function(value) {
        	if (!isNullOrEmpty(value)) {
            	return value;
        		 }else {
        			 return "";
        		 }
    	}
},{
		text : getHostelTranslation('ADMISSIONID'),
		dataIndex : 'admissionCode',
		hidden:true,
		flex:1
	},{
		text : getHostelTranslation('ADDRESS'),
		dataIndex : 'address',
		hidden:true,
		flex:1
	},{
		text : getHostelTranslation('FATHER_NAME'),
		dataIndex : 'fathersName',
		hidden:true,
		flex:1
	},{
		text : getHostelTranslation('MOBILE_NO'),
		dataIndex : 'contactNo',
		hidden:true,
		flex:1
	},{
		text : getHostelTranslation('EMAIL_ID'),
		dataIndex : 'emailId',
		hidden:true,
		flex:1
	},{
		header : getHostelTranslation('HOSTEL_CODE_NAME'),
		dataIndex : 'hostelCode',
		flex:1,
		 renderer:function(value,record){
			 var hostelCodeName='';
			 if(!isNullOrEmpty(record.record.get("hostelCode") )){
				 var hostelCode = record.record.get("hostelCode");
				 var hostelName = record.record.get("hostelName");
				 hostelCodeName = hostelCode+ '/' +hostelName;
			 }
			 return  hostelCodeName;			 
		}
	},{
		header : getHostelTranslation('BUILDING_CODE_NAME'),
		dataIndex : 'buildingCode',
		flex:1,
		 renderer:function(value,record){
			 var buildingCodeName='';
			 if(!isNullOrEmpty(record.record.get("buildingCode") )){
				 var buildingCode = record.record.get("buildingCode");
				 var buildingName = record.record.get("buildingName");
				 buildingCodeName = buildingCode+ '/' +buildingName;
			 }
			 return  buildingCodeName;			 
		}
	},{
		header : getHostelTranslation('FLOOR_NO'),
		dataIndex : 'floorNo',
		flex:1
	},{
		header : getHostelTranslation('ROOM_NO'),
		dataIndex : 'roomNo',
		flex:1
	},{
		header : getHostelTranslation('ROOM_TYPE'),
		dataIndex : 'roomType',
		flex:1
	},{
		header : getHostelTranslation('TOTAL_NO_OF_BEDS'),
		dataIndex : 'noOfBeds',
		flex:1,
		summaryType: 'sum',
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		},
		/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		}*/
	},{
		header : getHostelTranslation('OCCUPIED_BEDS'),
		dataIndex : 'noOfOccupiedBeds',
		flex:1,
		summaryType: 'sum',
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		},
		/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		}*/
	},{
		header : getHostelTranslation('AVAILABLE_BEDS'),
		dataIndex : 'noOfAvailableBeds',
		flex:1,
		summaryType: 'sum',
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		},
		/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		}*/
	}/*,{
		header : getHostelTranslation('AVAILABLE_FROM'),
		dataIndex : 'availableFrom',
		flex:1
	}*/,{
		header : getHostelTranslation('CURRENT_STATUS'),
		dataIndex : 'currentStatus',
		flex:1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'ALLOTTED' || value == 'Allotted'){
					return  getHostelTranslation('ALLOTTED');
				}else if(value == 'CANCELLED' || value == 'Cancelled'){
					return  getHostelTranslation('CANCELLED');
				}else if(value == 'CHECKED_IN' || value == 'Checked In'){
					return getHostelTranslation('CHECKED_IN');
				}else if(value == 'CHECKED_OUT' || value == 'Checked Out'){
					return getHostelTranslation('CHECKED_OUT');
				} 
			}
		}
	},{
		header : getHostelTranslation('BED_NO'),
		dataIndex : 'bedNo',
		flex:1
	},{
		header : getHostelTranslation('CHECKED_IN_DATE'),
		dataIndex : 'checkInDate',
		flex:1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getHostelTranslation('EXPECTED_CHECK_OUT'),
		dataIndex : 'expectedCheckOutDate',
		flex:1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getHostelTranslation('ALLOTMENT_DATE'),
		dataIndex : 'allotmentDate',
		hidden:true,
		flex:1,	
		renderer: function(date) {
		return dateRender(date);
	  }
	}
	/*,{
		header : getHostelTranslation('STATUS'),
		dataIndex : 'status',
		flex : 1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'ACTIVE' || value == 'Active'){
					return '<span style="color:green;">' + getHostelTranslation('ACTIVE') + '</span>';
				}else{
					return '<span style="color:red;">' + getHostelTranslation('IN_ACTIVE') + '</span>';
				} 
			}
		}
	}*/]
});