/**
 *  @author Dharmendra.p
 */
Ext.define('Academia.view.hostel.roomallocation.roomwise.RoomWiseList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.roomwiselist',
//	store : 'hostel.managehostel.room.ManageRoomDetails',
	store :'',
	title: getHostelTranslation('LIST_OF_ROOMS'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : '',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAllotRoom',
		text: getHostelTranslation('ALLOT_ROOM')
	}/*,{
		xtype: 'button',
		itemId: 'btnCancelAllotment',
		text: getHostelTranslation('CANCEL_ALLOTMENT')
	},{
		xtype: 'button',
		itemId: 'btnCheckIn',
		text: getHostelTranslation('CHECK_IN')
	},{
		xtype: 'button',
		itemId: 'btnCheckOut',
		text: getHostelTranslation('CHECK_OUT')
	}*/],
	columns: [{
		header : getHostelTranslation('STUDENT_ID'),
		dataIndex : 'studentId',
		flex:1
	},{
		header : getHostelTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getHostelTranslation('PROGRAM'),
		dataIndex : 'program',
		flex:1
	},{
		header : getHostelTranslation('BATCH'),
		dataIndex : 'batch',
		flex:1
	},{
		header : getHostelTranslation('SEAT_TYPE'),
		dataIndex : 'seatType',
		flex:1
	},{
		header : getHostelTranslation('ALLOTMENT_STATUS'),
		dataIndex : 'allotmentStatus',
		flex:1
	},{
		header : getHostelTranslation('BED_NO'),
		dataIndex : 'bedNo',
		flex:1
	},{
		header : getHostelTranslation('ALLOTMENT_DATE'),
		dataIndex : 'allotmentDate',
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getHostelTranslation('CHECK_IN_DATE'),
		dataIndex : 'checkInDate',
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	}]
});