/**
 * Dharmendra.p
 */
Ext.define('Academia.view.hostel.roomallocation.userwise.CancelAllotmentList', {
	extend: 'Ext.grid.Panel',
    alias : 'widget.cancelallotmentlist',
    store : 'hostel.roomallocation.userwise.CancelAllotmentList',
    title:getHostelTranslation('ALLOTMENT_DETAILS'),
    selType:'checkboxmodel',
    border: true,
    isFixHeightGrid: true,
    viewConfig : {
    	stripeRows : CONSTANTS.STRIPEROWS
    },
    columns : [{
		header :getHostelTranslation('OCCUPANT_ID'),
		dataIndex : 'code',
		flex:1
	},{
		header : getHostelTranslation('OCCUPANT_NAME'),
		dataIndex : 'name',
		flex:1
	},{
		header : getHostelTranslation('USER_TYPE'),
		dataIndex : 'userType',
		flex:1
	},{
		header : getHostelTranslation('BED_NO'),
		dataIndex : 'bedNo',
		flex:1
	},{
		header : getHostelTranslation('ALLOTMENT_STATUS'),
		dataIndex : 'allotmentStatus',
		flex:1
	},{
		header : getHostelTranslation('FEE_PAYMENT'),
		dataIndex : 'feePaymentStatus',
		flex:1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'DONE' || value == 'Done'){
					return '<span style="color:green;">' + getHostelTranslation('DONE') + '</span>';
				}else if(value == 'PENDING' || value == 'Pending'){
					return '<span style="color:red;">' + getHostelTranslation('PENDING') + '</span>';
				} 
			}else{
				return '-';
			}
		}
	},{
		header : getHostelTranslation('HOSTEL_NAME'),
		dataIndex : 'hotelName',
		flex:1
	},{
		header : getHostelTranslation('ROOM_TYPE'),
		dataIndex : 'roomTypeName',
		flex:1
	},{
		header : getHostelTranslation('ROOM_NO'),
		dataIndex : 'roomNo',
		flex:1
	}]
});
