/**
 *  @author Dharmendra.p
 */
Ext.define('Academia.view.hostel.roomallocation.userwise.UserWiseList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.userwiselist',
	store :'hostel.roomallocation.userwise.UserWiseList',
	title: getHostelTranslation('LIST_OF_ROOMS'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	 headerFix:{
			headerFix: true,
			portalIdsWithStructure: {
				'hostelroomallocationstructure':1
			}
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.roomallocation.userwise.UserWiseList',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAllotRoom',
		text: getHostelTranslation('ALLOT_ROOM')
	}/*,{
		xtype: 'button',
		itemId: 'btnCancelAllotment',
		disabled:true,
		text: getHostelTranslation('CANCEL_ALLOTMENT')
	},{
		xtype: 'button',
		itemId: 'btnCheckIn',
		disabled:true,
		text: getHostelTranslation('CHECK_IN')
	},{
		xtype: 'button',
		itemId: 'btnCheckOut',
		disabled:true,
		text: getHostelTranslation('CHECK_OUT')
	}*/],
	columns: [{
		header : getHostelTranslation('HOSTEL_CODE_NAME'),
		dataIndex : 'hostelCode',
		flex:2,
		 renderer:function(value,record){
			 var hostelCodeName='';
			 if(!isNullOrEmpty(record.record.get("hostelCode") )){
				 var hostelCode = record.record.get("hostelCode");
				 var hostelName = record.record.get("hostelName");
				 hostelCodeName = hostelCode+ '/' +hostelName;
			 }
			 return  hostelCodeName;			 
		}
	},{
		header : getHostelTranslation('BUILDING_CODE_NAME'),
		dataIndex : 'buildingCode',
		flex:2,
		 renderer:function(value,record){
			 var buildingCodeName='';
			 if(!isNullOrEmpty(record.record.get("buildingCode") )){
				 var buildingCode = record.record.get("buildingCode");
				 var buildingName = record.record.get("buildingName");
				 buildingCodeName = buildingCode+ '/' +buildingName;
			 }
			 return  buildingCodeName;			 
		}
	},{
		header : getHostelTranslation('FLOOR_NO'),
		dataIndex : 'floorNo',
		flex:1
	},{
		header : getHostelTranslation('ROOM_NO'),
		dataIndex : 'roomNo',
		flex:1
	},{
		header : getHostelTranslation('ROOM_TYPE'),
		dataIndex : 'roomType',
		flex:1
	},{
		header : getHostelTranslation('TOTAL_NO_OF_BEDS'),
		dataIndex : 'noOfBeds',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},
	/*{
		header : getHostelTranslation('OCCUPIED_BEDS'),
		dataIndex : 'noOfOccupiedBeds',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getHostelTranslation('AVAILABLE_BEDS'),
		dataIndex : 'noOfAvailableBeds',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},*/
	{
		header : getHostelTranslation('ALLOTTED_COUNT'),
		dataIndex : 'noOfAllotted',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},
	{
		header : getHostelTranslation('AVAILABLE_FROM'),
		dataIndex : 'availableFrom',
		flex:1,
		renderer: function(date) {
			return dateRender(date);
		}
	}/*,{
		header : getHostelTranslation('STATUS'),
		dataIndex : 'status',
		flex : 1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'ACTIVE' || value == 'Active'){
					return '<span style="color:green;">' + getHostelTranslation('ACTIVE') + '</span>';
				}else{
					return '<span style="color:red;">' + getHostelTranslation('IN_ACTIVE') + '</span>';
				} 
			}
		}
	}*/]
});