/**
 * @author Ramkrishna Yadav
 */
Ext.define('Academia.view.hrRecruitmentProcess.jobApplication.JobApplicationGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.jobapplicationgrid',
    store: 'hrRecruitmentProcess.jobApplication.JobApplicationGridStore',
    title: getCommonTranslation('LIST_OF_JOB_APPLICATION'),
    border: true,
  //  frame: true,
    refreshStoreData:true,
    selType:'checkboxmodel',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
          store: 'hrRecruitmentProcess.jobApplication.JobApplicationGridStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid,false);
      this.callParent(arguments);
    },
    tbar: [{
		xtype: 'button',
		itemId: 'updateStatus',
		disabled:true,
		text: getCommonTranslation("UPDATE_STATUS"),
		
		
	}, {
		xtype: 'button',
		itemId: 'updateJoiningStatus',
		disabled:true,
		text: getCommonTranslation("UPDATE_JOINING_STATUS"),
		
	},{
        xtype: 'button',
        itemId: 'sendMessageBtn',
        text:getCommonTranslation('SEND_MESSAGE')
    }, {
        xtype: 'button',
        itemId: 'exportJobApplicationReport',
       text:getCommonTranslation('EXPORT_REPORT'),
       tooltip:getCommonTranslation('EXPORT_REPORT'),
    }],
    columns: [{
        header:getAdmissionTranslation('APPLICATION_ID'),
        dataIndex: 'code',
        flex: 1,
        sortable: true
    }, {
        header: getCommonTranslation("JOB_APPLICATION_NAME"),
        dataIndex: 'applicantName',
        flex: 1,
        sortable: true,
      
    },{
        header:getCommonTranslation("JOB_TITLE"),
        dataIndex: 'jobTitle',
        flex: 1,
        sortable: true
    },{
        header:getPersonModuleTranslation('DESIGNATION'),
        dataIndex: 'designationName',
        flex: 1,
        sortable: true
    },{
        header: getCommonTranslation("APPLICATION_STATUS"),
        dataIndex: 'jobApplicationStatus',
        flex: 1,
        sortable: true,
         renderer: function(value) {
        	if (!isNullOrEmpty(value)) {
        		if(value=="CONTACTED"){
        			value = getCommonTranslation(value)
        		}else
        			value = getAdmissionTranslation(value);
        	} else {
        		value = '';
        	}
        	return value;
        }
    },{
        header: getCommonTranslation("NO_OF_YEARS_OF_EXPERIENCE"),
        dataIndex: 'yearsOfExperience',
        flex: 1,
        sortable: true
    },{
        header: getCommonTranslation('NOTICE_PERIOD'),
        dataIndex: 'noticePeriod',
        flex: 1,
        sortable: true
    }, {
        header: getCommonTranslation('REMARKS'),
        dataIndex: 'remarks',
        flex: 1,
        sortable: true
        
    
    },{
        header: getCommonTranslation('NO_OF_DOCUMENT'),
        dataIndex: 'identityDetails',
        flex: 1,
        sortable: true,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(record.data.identityDetails)){
        		if(!isNullOrEmpty(record.data.identityDetails[0].documents[0])){
        		return '<a href=#>'+record.data.identityDetails.length+'</a>';
        		}else {
            		return '-';
        		}
        		} else {
        		return '-';
        	}
        }
    }, {
        header: getAdmissionTranslation('EMAIL_ID'),
        dataIndex: 'emailId',
        flex: 1,
        sortable: true,
        hidden: true
    }, {
        header: getAdmissionTranslation('MOBILE_NO'),
        dataIndex: 'mobileNumber',
        flex: 1,
        sortable: true,
        hidden: true
    }, {
        header: getPersonModuleTranslation('HIGHEST_QUALIFICATION'),
        dataIndex: 'highestQualification',
        flex: 1,
        sortable: true,
        hidden: true,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(record)){
        		return record.data.highestQualification.education;
        	} 
        }
    }, {
        header: getCommonTranslation('LANGUAGE'),
        dataIndex: 'language',
        flex: 1,
        sortable: true,
        hidden: true,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(value)){
        		return '<a href=#>'+'View'+'</a>';
        	} else {
        		return '-';
        	}
        }
    }], 
   
});