Ext.define('Academia.view.hrRecruitmentProcess.jobPosting.JobPostingSetupDataRequirementGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.jobpostingsetupdatarequirementgrid',	
	store:'hrRecruitmentProcess.jobPosting.JobPostingSetupDataRequirementStore', 
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	frame:false,
	width:800,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar:[{
		xtype:'button',
		text:getCommonTranslation('SAVE'),
		action:'save',
		itemId:'btnSaveDataReq'
	}],	
	columns:[{
		header:getCommonTranslation('SETUP_EXAM_PASSED'),
		dataIndex:'displayName',
		sortable: false,
		flex:0.1,
		renderer:function(value) {
			return value;
		}	
	},{
		header:getCommonTranslation('MINIMUM_MANDATORY_ENTRIES'),
		flex:.05,
		dataIndex : 'minimumEntry',
		sortable: false,
		editor: {
        	xtype: 'numberfield',
        	name: 'minmumMandatoryEntries',
        	minValue:0,
        	maxLength: 6,
        	width: 12,
        	enforceMaxLength : true,
        	keyNavEnabled: false,
        	mouseWheelEnabled: false,
        	allowDecimals:false,
        	itemId: 'sequenceNoItemId',
        	listeners: {
        		change: function(obj, record){
        			var grid = obj.up('grid')
        			var selectedRecord = grid.getSelectionModel().getSelection()[0];
        			if(selectedRecord.data.maximumEntry<record){
        				obj.reset();
        			}
        		}
        	}
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(record.data.moduleName != 'Program Details'){
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					rec.tdCls = 'gridInputCustomStyleForSqeuence';
					return value;
				}
				catch(e){
					return null;
				}
			}
        	else {
        		rec.tdCls = 'gridInputCustomStyleForSqeuence';
	                return '0';
        	}
        	}
        }			
	},{
		header:getCommonTranslation('ALLOWED_ENTRIES_MAXIMUM'),
		flex:.05,
		sortable: false,
		dataIndex : 'maximumEntry',
		editor: {
        	xtype: 'numberfield',
        	name: 'allowedEntries',
        	minValue:0,
        	maxLength: 6,
        	width: 12,
        	enforceMaxLength : true,
        	keyNavEnabled: false,
        	mouseWheelEnabled: false,
        	allowDecimals:false,
        	itemId: 'sequenceNoItemId'
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(record.data.moduleName != 'Program Details'){
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					rec.tdCls = 'gridInputCustomStyleForSqeuence';
					return value;
				}
				catch(e){
					return null;
				}
			}
        	else {
        			rec.tdCls = 'gridInputCustomStyleForSqeuence';
	                return '0';
        	}
        	}
        }			
	},{
		xtype:'checkcolumn',
		header:getCommonTranslation('MODULE_VISIBILITY'),
		flex:.1,
		dataIndex : 'isVisible',
		align:"left",
		sortable: false,
		renderer: function(value, metadata,record) {
			var data=record.data;
			if(data.moduleName != 'Program Details'){
				 var cssPrefix = Ext.baseCSSPrefix,
				 cls = cssPrefix + 'grid-checkcolumn';
				 if (value) {
						cls += ' ' + cssPrefix + 'grid-checkcolumn-checked';
					}
					return '<img class="' + cls + '" src="' + Ext.BLANK_IMAGE_URL + '"/>';
			}
		}			
	},{
		xtype:'checkcolumn',
		flex:.1,
		sortable: false,
		align:"left",
		header:getCommonTranslation('MANDATORY'),
		dataIndex : 'isMandatory'	,
		renderer: function(value, metadata,record) {
			var data=record.data;
			if(data.moduleName != 'Program Details'){
				 var disabled=!data.isVisible;
				 if(disabled){
					 metadata.style+= ' opacity:0.3';
					 value=data.isMandatory;
				 }
				
				 var cssPrefix = Ext.baseCSSPrefix,
				 cls = cssPrefix + 'grid-checkcolumn';
				 if (value) {
						cls += ' ' + cssPrefix + 'grid-checkcolumn-checked';
					}
					return '<img class="' + cls + '" src="' + Ext.BLANK_IMAGE_URL + '"/>';
			}
		},
		 processEvent: function(type, view, cell, recordIndex, cellIndex, e) {
			 if (type == 'mousedown' || (type == 'keydown' && (e.getKey() == e.ENTER || e.getKey() == e.SPACE))) {
				var record = view.panel.store.getAt(recordIndex);
				var data=record.data;
				var disabled=!data.isVisible;
				 //do not change data and fire checkchange event if it's disabled
				 view.focusRow(recordIndex);
				 if (!disabled) {
	                        dataIndex = this.dataIndex;
	                        checked = !record.get(dataIndex);
	                        record.set(dataIndex, checked);
	                        this.fireEvent('checkchange', this, recordIndex, checked);
	              }
				 return false;
                }
            }	
	},{
        xtype:'actioncolumn',
        text : getCommonTranslation('SETUP_SEQUENCE'),
        menuText: getCommonTranslation('SETUP_SEQUENCE'),
        flex: 0.1,
        width:50,
        sortable : false,
        items: [{
        	xtype: 'button',
        	itemId: 'upButton',
        	iconCls: Ext.baseCSSPrefix + 'form-itemselector-up',  // Use a URL in the icon config
            tooltip: 'UP',
            handler: function(grid, rowIndex, colIndex) {
            	if(rowIndex != 0) {
	            	var record = grid.getStore().getAt(rowIndex);
	            	var previousRecord = grid.getStore().getAt(rowIndex-1); 
	            	previousRecord.set('stageOrder', (previousRecord.get('stageOrder'))+1);
	            	record.set('stageOrder', (record.get('stageOrder'))-1);
	            	grid.getStore().sort();
	            	
	            	grid.getStore().remove(record, true);
                    grid.getStore().insert(rowIndex-1, record);
                    grid.getStore().remove(previousRecord, true);
                    grid.getStore().insert(rowIndex, previousRecord);
            	} else {
            		showErrorMessage(getCommonTranslation('REORDER'), getErrorTranslation('UPERRORMESSAGE'));
            	}
            }
        },{
        	xtype: 'button',
        	itemId: 'downButton',
        	iconCls: Ext.baseCSSPrefix + 'form-itemselector-down',
            tooltip: 'DOWN',
            handler: function(grid, rowIndex, colIndex) {
            	lastRowIndex = grid.getStore().getCount()-1;
            	if(rowIndex != lastRowIndex) {
	            	var record = grid.getStore().getAt(rowIndex);
	            	var nextRecord = grid.getStore().getAt(rowIndex+1); 
	            	nextRecord.set('stageOrder', (nextRecord.get('stageOrder'))-1);
	            	record.set('stageOrder', (record.get('stageOrder'))+1);
	            	
	            	grid.getStore().remove(record, true);
                    grid.getStore().insert(rowIndex+1, record);
                    grid.getStore().remove(nextRecord, true);
                    grid.getStore().insert(rowIndex, nextRecord);
            	} else {
            		showErrorMessage(getCommonTranslation('REORDER'), getErrorTranslation('DOWNERRORMESSAGE'));
            	}
            }
        }]
	}],
    plugins: {
        ptype: 'cellediting',
        clicksToEdit: 1
    }
}
);