/**
 * @author Bhartendu Bhaskar
 * 
 */
Ext.define('Academia.view.hrm.HRMEmployeeAttendanceFilter', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.hrmemployeeattendancefilter',
    //autoScroll: true,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
        },
        items: [{
            xtype: 'label',
            text: getPersonModuleTranslation('HRM_ATTENDANCE_BY'),
            style: {
                marginTop: '5px',
                marginLeft: '2px !important'
            },
            width: 256
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
        },
        items: [{
            xtype: 'radiogroup',
            style: {
                marginLeft: '-2px !important'
            },
            itemId: 'attendanceByItemId',
            labelAlign: 'top',
            columns: 2,
            vertical: true,
            items: [{
                boxLabel: getPersonModuleTranslation('HRM_DATE_WISE'),
                name: 'attendanceBy',
                inputValue: 'DateWise'
            }, {
                boxLabel: getPersonModuleTranslation('HRM_EMPLOYEE_WISE'),
                name: 'attendanceBy',
                inputValue: 'EmployeeWise'
            }]
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            name: 'employeeId',
            itemId: 'employeeItemId',
            fieldLabel: getPersonModuleTranslation('HRM_EMPLOYEE_ID'),
            store: 'hrm.HRMEAEmployeeSmartSearchStore',
            valueField: 'id',
            displayField: 'valueCode',
            queryParam: 'codeOrName',
            triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            minChars: 3,
            typeAhead: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            //triggerAction: '',
            hideTrigger: false,
            maxLength: 100,
            allowBlank: false,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{studentCode} / {studentName}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'datefield',
            name: 'startDate',
            itemId: 'startDateItemId',
            vtype: 'daterange',
            endDateField: 'endDateItemId',
            maxValue: new Date(),
            fieldLabel: getPersonModuleTranslation('START_DATE'),
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            allowBlank: false,
            listeners: {
                render: function(obj) {
                    return dateFormatRender(obj);
                }
            }
        }, {
            xtype: 'datefield',
            name: 'endDate',
            itemId: 'endDateItemId',
            vtype: 'daterange',
            startDateField: 'startDateItemId',
            maxValue: new Date(),
            fieldLabel: getPersonModuleTranslation('END_DATE'),
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            allowBlank: false,
            listeners: {
                render: function(obj) {
                    return dateFormatRender(obj);
                }
            }
        }, {
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('LATE_ARRIVAL_EARLY_GOING'),
            name: 'lateArrivalEarlyGoingEWId',
            itemId: 'lateArrivalEarlyGoingEWId',
           // store: 'department.DepartmentAcademyLocationWiseStore',
            store: Ext.create('Ext.data.Store', { fields: ['name'], data: [{ name: 'Late Arrival' }, { name: 'Early Going' }] }),
            valueField: 'name',
            displayField: 'name',
            editable: false
        }, {
            xtype: 'nestedJsonCombo',
            fieldLabel: getCommonTranslation('DEPARTMENT'),
            name: 'departmentId',
            itemId: 'departmentItemId',
            store: 'department.DepartmentAcademyLocationWiseStore',
            valueField: 'id',
            displayField: 'value',
            hidden: true,
            editable: false
        }, {
            xtype: 'nestedJsonCombo',
            fieldLabel: getCommonTranslation('GROUP'),
            name: 'userGroupId',
            itemId: 'userGroupItemId',
            store: 'userGroup.UserGroupStore',
            valueField: 'id',
            displayField: 'userGroupName',
            //allowBlank: false,
            editable: false,
            hidden: true,
            queryMode: 'local'
        }, {
            xtype: 'datefield',
            name: 'date',
            itemId: 'dateItemId',
            vtype: 'daterange',
            fieldLabel: getCommonTranslation('DATE'),
            maxValue: new Date(),
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            allowBlank: false,
            hidden: true,
            listeners: {
                render: function(obj) {
                    return dateFormatRender(obj);
                }
            }
        },{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('LATE_ARRIVAL_EARLY_GOING'),
            name: 'lateArrivalEarlyGoingDWId',
            itemId: 'lateArrivalEarlyGoingDWId',
           // store: 'department.DepartmentAcademyLocationWiseStore',
            store: Ext.create('Ext.data.Store', { fields: ['name'], data: [{ name: 'Late Arrival' }, { name: 'Early Going' }] }),
            valueField: 'name',
            hidden: true,
            displayField: 'name',
            editable: false
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBtnHRMEmployeeAttendanceFilterItemId',
            ui: 'CustomBtnSubmit',
            formBind: true,
        }, {
            xtype: 'button',
            itemId: 'resetBtnHRMEmployeeAttendanceFilterItemId',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel'
        }, {
        	xtype: 'button',
        	text: 'Mark Default In/Out Time',//getCommonTranslation('SEARCH'),
        	itemId: 'markDefaultInOutBtnItemId',
        	ui: 'CustomBtnSubmit',
        	disabled: true,
        	style:{
            	'margin-right':'8px !important'
            }
        }]
    }]
});