/**
 * @author sohan chouhan
 * 
 */
Ext.define('Academia.view.hrm.availability.AvailabilitySettingWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.availabilitysettingwin',
    modal: true,
    frame: true,
    resizable: false,
    autoScroll: true,
    height: '45%',
    title: getCommonTranslation('AVAILABILITY_SETTING'),
    items: [{
        xtype: 'form',
        itemId:'availabilitysettingwin',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
    		xtype:'hidden',
    		name:'id',
    		itemId:'id'
    	},{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            items: [{
	            xtype: 'customcombobox',
				fieldLabel:  getCommonTranslation('ACADEMY_LOCATION'),
	            name: 'settingAcademyLocation',
	            itemId:'settingAcademyLocation',
	           store: 'user.UserAcademyLocationStore',
	            displayField: 'value',
	            valueField: 'id',
	            width: 256,
	            allowBlank: false,
	            typeAhead : true,
	            forceSelection:true,
	            hideTrigger:false,
	            queryParam:'qry',
	            labelAlign:'top',
	    	    triggerAction: 'all',
	    	    minChars:3,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            listConfig: {
					 
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{value}'  +
		                    '</div>';
		                }
		            }
	        },{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
			store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
			name : 'ACADEMIC_TERM',
			itemId : 'settingAcademicTerm',
			displayField : 'value',
			valueField : 'id',
			typeAhead : true,
			width: 256,
			labelAlign:'top',
			allowBlank: false,
			editable:false
		}]
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            items: [{
            	xtype: 'datefield',
                fieldLabel: getCommonTranslation('START_DATE'),
            	itemId: 'startDate',
                name: 'startDate',
                labelAlign: 'top',
                vtype: 'daterange',
                endDateField:'endDate',
                width: 256,
                listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
            },{
            	xtype: 'datefield',
            	fieldLabel: getProgramandcourseTranslation('END_DATE'),
            	itemId: 'endDate',
                name: 'endDate',
                labelAlign: 'top',
                width: 256,
                startDateField:'startDate',
                vtype: 'daterange',
                listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',            
            items: [{
                xtype: 'button',
                itemId: 'btnSaveAvaiSetting',
                text: getCommonTranslation('SAVE'), //Submit
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelAvaiSetting',
                text: getCommonTranslation('CANCEL'), //Cancel
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]

    }]
});