/**
 * @author sohan chouhan
 * 
 */
Ext.define('Academia.view.hrm.availability.HRMAvailabilityWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.hrmavailabilitywindow',
    modal: true,
    frame: true,
    resizable: false,
    autoScroll: true,
    height: '45%',
    title: getCommonTranslation('ADD_AVAILABILITY'), //Currency Details	
    items: [{
        xtype: 'form',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
    		xtype:'panel',
    		width:'100%',
    		itemId: 'empPanelId',
        items: [{
                xtype: 'fieldcontainer',
                //itemId:'empPanelId',
                layout: 'hbox',
                defaults: {
                    labelAlign: 'top',
                    width: '256'
                },
                items: [{
	                xtype: 'customcombobox',
	                name: 'employeeId',
	                itemId: 'employeeItemId',
	                fieldLabel: getPersonModuleTranslation('HRM_EMPLOYEE_ID'),
	                store: 'hrm.timesheet.HRMTEmployeeSmartSearchStore',
	                valueField: 'id',
	                displayField: 'valueCode',
	                queryParam: 'codeOrName',
	                triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
	                enableKeyEvents: 'true',
	                minChars: 3,
	                typeAhead: false,
	                forceSelection: true,
	                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	                // triggerAction: '',
	                hideTrigger: false,
	                allowBlank:false,
	                maxLength: 100,
	                listConfig: {
	                    listeners: {
	                        beforeshow: function(
	                            picker) {
	                            picker.minWidth = picker
	                                .up('combobox')
	                                .getSize().width;
	                        }
	                    },
	                    loadingText: getCommonTranslation('SEARCHING'),
	                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                    getInnerTpl: function() {
	                        return '<div class="search-item">' +
	                            '{studentCode} / {studentName}' +
	                            '</div>';
	                    }
	                }
	            }, {
	    			xtype: 'customcombobox',
	    			name: 'empDays',
	    			width:200,
	    			allowBlank: false,
	    			maxHeight:200,
	    			itemId: 'empDayId',
	    			autoScroll:true,
	    			store:'transport.serviceRoute.WeekDays',
	    			displayField: 'value',
	    			valueField: 'value',
	    			fieldLabel: getCommonTranslation('WEEKDAYS'),
	    			listConfig: {
	                    listeners: {
	                        beforeshow: function(
	                            picker) {
	                            picker.minWidth = picker
	                                .up('combobox')
	                                .getSize().width;
	                        }
	                    },
	                    loadingText: getCommonTranslation('SEARCHING'),
	                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                    getInnerTpl: function() {
	                        return '<div class="search-item">' +
	                            '{value}' +
	                            '</div>';
	                    }
	                }
	    		},{
					xtype : 'timefield',
					name : 'fromTime',		
					itemId : 'fromTime',			
					fieldLabel:getCommonTranslation('FROM_AVAILABLE'),
					format:'g:i A',
					increment: 1,
					vtype: 'timerange',
					width:200,
					listeners:{
						change:function(obj,val){
							if (!isNullOrEmpty(val)) {
								var sDate = Ext.Date.add(val, Ext.Date.MINUTE, 1);
								obj.nextSibling().setMinValue(sDate);	
							}
						}
					}
				},{
					xtype : 'timefield',
					name : 'toTime',		
					itemId : 'toTime',			
					fieldLabel:getCommonTranslation('TO_AVAILABLE'),
					format:'g:i A',
					vtype: 'timerange',
					increment: 1,
					width:200,
					listeners:{
						change:function(obj,val){
							if (!isNullOrEmpty(val)) {
								var eDate = Ext.Date.add(val, Ext.Date.MINUTE, -1);
								obj.previousSibling().setMaxValue(eDate);
							}
						}
					}
				},{
					xtype: 'textfield',
					name:'remark',
					itemId:'remark',
					width: 200,
					maxLength : 255,
					fieldLabel: getPersonModuleTranslation('REMARK')
				},{
					xtype: 'button',
					itemId: 'multiEmpAdd',
					cls: 'CustomBodyBtnSettings',
					text: getCommonTranslation('ADDBUTTONTEXT'),
					tooltip: getCommonTranslation('ADD'),
					style:{
						marginTop:'30px'
					}
				 }]
            },{
            xtype: 'fieldcontainer',
            width: '100%',   
            style:{
				marginTop:'30px'
			},
            items: [{
                xtype: 'button',
                itemId: 'btnSaveEmpDetails',
                text: getCommonTranslation('SAVE'), //Submit
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelEmpDetails',
                text: getCommonTranslation('CANCEL'), //Cancel
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
        }]
    }]
});