/**
 *@author Varsha Gour
 */
Ext.define('Academia.view.hrm.biometric.BMIMachineDetailsGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.bmimachinedetailsgrid',
    //store: 'hrm.biometric.BMIMachineDetailsStore',
    title: getCommonTranslation('BMI_MACHINE_DETAILS_ON_PROFILE'),
    autoScroll: false,
	border: true,
    //frame:false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    initComponent: function() {
    	var this$ = this;
    	var store = this$.buildStore();
    	Ext.apply(this$, {
    		store: store,
    		dockedItems: [{
    			xtype: 'toolbar',
    			dock: 'bottom',
    			items: [{
    				xtype: 'custompagingtoolbar',
    				plugins: ['pagesize'],
    				store: store,
    				emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
    				displayInfo: true
    			}]
    		}]
    	});
    	this$.addExportToolBarItems(this$);
    	this$.callParent(arguments);
    },
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}],
    columns: [{
        header: getCommonTranslation('BMI_MACHINE_ID'),
        dataIndex: 'machineCode',
        flex:1,
        sortable:true
    },{
        header: getCommonTranslation('BMI_MACHINE_NAME'),
        dataIndex: 'machineName',
        flex:1,
        sortable:true
    }, {
        header: getCommonTranslation('BMI_MACHINE_USER_ID'),
        dataIndex: 'clientUserId',
        flex:1,
        sortable: true
    },{
		header:  getCommonTranslation('STATUS'),
		dataIndex: 'status',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			if(value == false || value == 'false'){
				return 'Inactive';
			} else {
				return 'Active';
			}

		} 
	}/* {
        header: getCommonTranslation('BMI_MACHINE_IP'),
        dataIndex: 'machineIp',
        hidden:true,
        flex:.3,
    }, {
        header: getCommonTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocation',
        flex:.3,
        hidden:true
    }, {
        header: getCommonTranslation('RESOURCE_NAME'),
        dataIndex: 'resourceName',
        flex:.3,
        hidden:true
    }, {
        header: getCommonTranslation('ACTION'),
        dataIndex: 'action',
        flex:.3,
        hidden:true
    }, {
        header: getExaminationTranslation('STATUS'),
        dataIndex: 'status',
        flex:.3,
        hidden:true
    }*/],
    buildStore: function() {
        return Ext.create('Academia.store.hrm.biometric.BMIMachineDetailsStore');
    }
});