/**
 * @author Deepak Sharma
 * 
 */
Ext.define('Academia.view.hrm.biometric.BMIStudentDownloadForm',{
	extend : 'Ext.form.Panel',
	alias : 'widget.bmistudentdownloadform',
	frame: false,
	method : 'POST',
	standardSubmit : false,
	width:'auto',
	height:'auto',
	items : [{
		xtype:'fieldcontainer',
		layout : 'hbox',
		width: 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'machineName',
			itemId:'machineName',
			fieldLabel : getCommonTranslation('BMI_MACHINE_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			allowBlank: false,
			listeners:{
				render : function(combo){
					var store=Ext.create('Academia.store.hrm.biometric.BMIMachineNameStore');
					combo.bindStore(store)
				}
			},
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
			name: 'lmAcademyLocationComboAS',
			itemId: 'lmAcademyLocationComboAS',
			disabled:true,
			editable: false,
			store: 'hrm.biometric.BMIMachineAcademyLocationStore',
			valueField: 'academyLocationIdtemp',
			displayField: 'academyLocationName',
			allowBlank: false
		}]
	},/*{
		xtype:'fieldcontainer',
		layout : 'hbox',
		width: 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'PROGRAM_NAME',
			store: 'feeandpayment.ProgramSmartSearchStore',
			itemId:'program',
			fieldLabel: getCommonTranslation('PROGRAM'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'qry',
			minChars:3,
			//disabled:true,
			allowBlank: true,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			}

		},{
			xtype: 'customcombobox',
			name: 'BATCH_NAME',
			itemId: 'batch',
			fieldLabel: getPersonModuleTranslation('BATCH'),
			store : 'enquiry.AcademicBatchStore',
			//disabled:true,
			editable: false,
			queryMode: 'local',
			displayField: 'value',
			valueField: 'id',
		},{
			xtype: 'customcombobox',
			itemId:'period',
			//disabled:true,
			editable: false,
			displayField: 'value',
			valueField: 'id',
			queryMode: 'local',
			fieldLabel: getPersonModuleTranslation('PERIOD'),
			name: 'PERIOD_NAME',
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
					combo.bindStore(store);
				}
			}
		}]
	},*//*{
		xtype:'fieldcontainer',
		layout : 'hbox',
		width: 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'COURSE_NAME',
			itemId: 'course',
			store: Ext.create('Academia.store.programCourseDashboard.CoursesByBatchStore'),
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			queryMode: 'name',
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			//disabled:true,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'SECTION',
			itemId: 'section',
			fieldLabel: getPersonModuleTranslation('SECTION'),
			editable: false,
			queryMode: 'local',
			//disabled:true,
			valueField: 'sectionId',
			displayField: 'sectionCode',
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID');
					combo.bindStore(store);
				}
			}
		}]
	},*/{
		xtype:'fieldcontainer',
		layout : 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items:[{
			xtype: 'button',
			text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
			itemId: 'downoladBtnIdAS',
			disabled:true,
			ui: 'CustomBtnSubmit'
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'resetBtnAS',
			//buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
