/**
 * 
 */
Ext.define('Academia.view.hrm.employeePortal.HRMMyPunchLogFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.hrmmypunchlogfilter',
    autoScroll: true,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'datefield',
            name: 'startDate',
            itemId: 'startDateItemId',
            vtype: 'daterange',
            endDateField: 'endDateItemId',
            maxValue: new Date(),
            fieldLabel: getPersonModuleTranslation('START_DATE'),
            allowBlank: false,
            listeners: {
                render: function(obj) {
                    return dateFormatRender(obj);
                }
            }
        }, {
            xtype: 'datefield',
            name: 'endDate',
            itemId: 'endDateItemId',
            vtype: 'daterange',
            startDateField: 'startDateItemId',
            maxValue: new Date(),
            fieldLabel: getPersonModuleTranslation('END_DATE'),
            allowBlank: false,
            listeners: {
                render: function(obj) {
                    return dateFormatRender(obj);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBtnHRMMyPunchLogFilterItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'resetBtnHRMMyPunchLogFilterItemId',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});