/**
 * @author Ramkrishna Yadav
 * 
 */
Ext.define('Academia.view.hrm.report.HRMAttendanceStatusReportFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.hrmattendancestatusreportfilter',
    autoScroll: true,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('FROM_DATE'),
            name: 'fromDate',
            itemId: 'fromDateItemId',
            endDateField: 'toDateItemId',
            format: CONSTANTS.DATE_FORMAT,
            allowBlank: false,
            vtype: 'daterange',
            editable:false,
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        }, {
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('To_Date'),
            name: 'toDate',
            itemId: 'toDateItemId',
            startDateField: 'fromDateItemId',
            format: CONSTANTS.DATE_FORMAT,
            allowBlank: false,
            editable:false,
            vtype: 'daterange',
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        },{
        	xtype: 'customcombobox',
        	name: 'employeeId',
        	itemId: 'attendanceStatusReportEmpItemId',
        	fieldLabel: getPersonModuleTranslation('HRM_EMPLOYEE_ID'),
        	store: 'hrm.HRMEAEmployeeSmartSearchStore',
        	valueField: 'id',
        	displayField: 'valueCode',
        	queryParam: 'codeOrName',
        	triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        	enableKeyEvents: 'true',
        	minChars: 3,
        	typeAhead: false,
        	forceSelection: true,
        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	hideTrigger: false,
        	maxLength: 100,
        	listConfig: {
        		listeners: {
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        		getInnerTpl: function() {
        			return '<div class="search-item">' +
        			'{studentCode} / {studentName}' +
        			'</div>';
        		}
        	}

        }]
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'nestedJsonCombo',
            fieldLabel: getCommonTranslation('DEPARTMENT'),
            name: 'department',
            itemId: 'attendanceStatusReportDepartmentItemId',
            store: 'department.DepartmentAcademyLocationWiseStore',
            valueField: 'id',
            displayField: 'value',
            editable: false
        }, {
            xtype: 'nestedJsonCombo',
            fieldLabel: getCommonTranslation('USER_GROUP_TYPE'),
            name: 'userGroupId',
            itemId: 'attendanceStatusReportUserGroupItemId',
            store: 'userGroup.UserGroupStore',
            valueField: 'id',
            displayField: 'userGroupName',
            editable: false,
            queryMode: 'local'
        },{
        	xtype: 'nestedJsonCombo',
            fieldLabel: getExaminationTranslation('ATTENDANCE_STATUS'),
            name: 'status',
            itemId: 'statusItemId',
            store: 'hrm.AttendanceStatusStore',
            valueField: 'value',
            displayField: 'value',
            editable: false,
            queryMode: 'local'
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchAttendanceStatusReportFilterItemId',
            //buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'resetAttendanceStatusReportFilterItemId',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});