/**
 * @author Deepak Sharma
 * 
 */
Ext.define('Academia.view.hrm.report.HRMWorkingHourReportFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.hrmworkinghourreportfilter',
    autoScroll: true,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'nestedJsonCombo',
            fieldLabel: getCommonTranslation('DEPARTMENT'),
            name: 'department',
            itemId: 'workingHourDepartmentItemId',
            store: 'department.DepartmentAcademyLocationWiseStore',
            valueField: 'id',
            displayField: 'value',
            editable: false
        }, {
            xtype: 'nestedJsonCombo',
            fieldLabel: getCommonTranslation('USER_GROUP_TYPE'),
            name: 'userGroupId',
            itemId: 'workingHourUserGroupItemId',
            store: 'userGroup.UserGroupStore',
            valueField: 'id',
            displayField: 'userGroupName',
            editable: false,
            queryMode: 'local'
        },
        {
        	xtype: 'customcombobox',
        	name: 'employeeId',
        	itemId: 'workingHourEmpItemId',
        	fieldLabel: getPersonModuleTranslation('HRM_EMPLOYEE_ID'),
        	store: 'hrm.HRMEAEmployeeSmartSearchStore',
        	valueField: 'id',
        	displayField: 'valueCode',
        	queryParam: 'codeOrName',
        	triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        	enableKeyEvents: 'true',
        	minChars: 3,
        	typeAhead: false,
        	forceSelection: true,
        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	//triggerAction: '',
        	hideTrigger: false,
        	maxLength: 100,
        	//allowBlank: false,
        	listConfig: {
        		listeners: {
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        		getInnerTpl: function() {
        			return '<div class="search-item">' +
        			'{studentCode} / {studentName}' +
        			'</div>';
        		}
        	}

        },
        {
			xtype: 'checkboxfield',
			name: 'viewEmployeeWithNoCalendar',
			itemId:'viewEmployeeWithNoCalendarItemId',
			style: {
				marginTop: '25px',
				marginLeft: '10px'
			},
			boxLabel: getPersonModuleTranslation('HRM_VIEW_EMPLOYEES_WITH_NO_CALENDAR'),
			inputValue : true,
			uncheckedValue: false 
		}]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        layout: 'hbox',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchHRMWorkingHourReportFilterItemId',
            //buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
            //formBind: true
        }, {
            xtype: 'button',
            itemId: 'resetHRMWorkingHourReportFilterItemId',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});