/**
 * @author Deepak Sharma
 * 
 */
Ext.define('Academia.view.hrm.timesheet.HRMTimesheetPeriodWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.hrmtimesheetperiodwindow',
    modal: true,
    resizable: false,
    title: getPersonModuleTranslation('HRM_TIMESHEET_PERIOD'),
    width : '58%',
    margin: 0,
    items: [{
        xtype: 'form',
        itemId: 'hrmTimesheetPeriodFormItemId',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
            xtype: 'hidden',
            itemId: 'hrmTimesheetPeriodId',
            name: 'id'
        },{
            xtype: 'hidden',
            itemId: 'version',
            name: 'version'
        },   {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                fieldLabel: getCommonTranslation('TIME_SHEET_NAME'),
                xtype: 'textfield',
                itemId: 'timesheetNameItemId',
                name: 'timesheetName',
                labelAlign: 'top',
                maxLength: 255,
                allowBlank: false
            },{
                xtype: 'radiogroup',
                itemId: 'timesheetPeriodTypeItemId',
                fieldLabel: getPersonModuleTranslation('HRM_TIMESHEET_DAYS'),
                allowBlank: false,
                style: {
                    marginLeft: '8px'
                },
                columns: 3,
                width: '52%',
                items: [{
                    boxLabel: getCommonTranslation('FIXED'),
                    name: 'timesheetPeriodType',
                    //itemId: 'preDefined',
                    inputValue: 'FIXED',
                    checked: true

                }, {
                    boxLabel: getCommonTranslation('DYNAMIC'),
                    name: 'timesheetPeriodType',
                    //itemId: 'other',
                    inputValue: 'DYNAMIC',
                },{
                    boxLabel: getProgramandcourseTranslation('CALENDAR_DAYS'),
                    name: 'timesheetPeriodType',
                    //itemId: 'preDefined',
                    inputValue: 'CALENDARDAYS',
                }]
            },{
				xtype: 'numberfield',
				fieldLabel: getPersonModuleTranslation('HRM_DAYS'),
				name: 'days',
				itemId:'daysItemId',
				allowBlank: false,
				value: 1,
				minValue : 1,
				maxValue: 31,
				maxLength: 3,
				width: 80
			}]
        },{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'datefield',
                fieldLabel:  getCommonTranslation('START_DATE'),
                name: 'startDate',
                itemId: 'startDate',
                allowBlank: false,
                listeners: {
                    render: function(obj) {
                        obj = dateFormatRender(obj);
                    }
                },
                endDateField : 'endDate',
    	        vtype : 'daterange'
            },{
                xtype: 'datefield',
                fieldLabel:  getCommonTranslation('TILL_DATE'),
                name: 'endDate',
                itemId: 'endDate',
                allowBlank: false,
                listeners: {
                    render: function(obj) {
                        obj = dateFormatRender(obj);
                    }
                },
                startDateField : 'startDate',
    	        vtype : 'daterange'
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',

            items: [{
                xtype: 'button',
                itemId: 'btnSaveTimesheetPeriodForm',
                text: getCommonTranslation('SAVE'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelTimesheetPeriodForm',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]

    }]
});
