/**
 * @author Santosh Sahu
 * 
 */
Ext.define('Academia.view.kohalibrarytransaction.LibraryCirculationHistoryFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.librarycirculationhistoryfilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'vbox',
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items :[{
				xtype : 'customcombobox',
				fieldLabel : getPersonModuleTranslation('TITLE'),		
				name : 'title',
				itemId : 'title',
				displayField : 'value',
				valueField : 'value',
				store:'kohalibrarytransation.LibraryBookTitleStore',
				typeAhead : true,
				forceSelection : true,
				hidden : false,
				width: 256
			},{
				xtype: 'customcombobox',
				fieldLabel: getPersonModuleTranslation('AUTHOR_NAME'),
				name:'author',
				itemId: 'author',
				store:Ext.create('Academia.store.kohalibrarytransation.LibraryBookAuthorStore'),
				displayField: 'value',
				valueField: 'value',
				typeAhead:true,
				forceSelection:true,
				allowBlank:true,
				disabled:false
			}]
		},{
				xtype:'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					labelAlign:'top',
					width: 256
				},
			items :[{
						xtype : 'datefield',
						fieldLabel : getPersonModuleTranslation('ISSUE_FROM_DATE'),
						name : 'startDate',
						itemId:'startDate',
						endDateField : 'endDate',
						//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
						vtype : 'daterange',
						width: 256,
						maxValue:new Date(),
						listeners: {
							render: function(field) {
								return dateFormatRender(field);
							}
						}
					},{
						xtype : 'datefield',
						fieldLabel :getPersonModuleTranslation('ISSUE_TO_DATE'),
						name : 'endDate',
						itemId : 'endDate',
						startDateField : 'startDate',
						//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
						vtype : 'daterange',
						width: 256,
						maxValue:new Date(),
						listeners: {
							render: function(field) {
								return dateFormatRender(field);
							}
						}
					}]
			}],
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'circulationBookSearchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'circulationBookResetBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
});
