/**
 * @author Manas.Luktuke
 */
Ext.define('Academia.view.learningtarget.LearningTargetsCoreGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.learningtargetscoregrid',
    title: getCommonTranslation('LEARNING_TARGETS'),
    border: true,
    /*headerFix:{
        headerFix: true,
        portalIdsWithStructure: {
            'learningtargetstructure':1
        }
    },*/  
    store: 'program.programDetails.programBatches.courseParameter.LearningTargetsGridStore',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        /*listeners: {
            cellclick: function(view, cell, cellIdx, record, row, rowIdx, eOpts) {
                targetedCell = cellIdx;
            }
        }*/
    },
    selType:'checkboxmodel',
    selModel: {
    	showHeaderCheckbox: true,
    	checkOnly : true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
    	allowDeselect: false,
    	/*listeners: {
            beforedeselect: function (thisSelModel, record, idx, eOpts) {
                if(targetedCell != 0) {
                	return false;
                }
                return true;
            }
        }*/
    },
    columns: [{
    	xtype: 'rownumberer',
        header: getCommonTranslation('S_NO'),
        dataIndex: 'sNo',
        sortable:false,
        flex:.5
    }, {
		header:getCommonTranslation('STUDENT_CODE'),
		dataIndex: 'studentCode',
		flex:1,
		sortable:true
	},  {
		header:getCommonTranslation('STUDENT_FIRST_NAME'),
		dataIndex: 'studentFirstName',
		flex:1,
		sortable:true
	},{
        header: getCommonTranslation('STUDENT_LAST_NAME'),
        dataIndex: 'studentLastName',
        sortable: true
    },{
        header: getCommonTranslation('COURSE'),
        dataIndex: 'courseName',
        flex:1,
        sortable: true
    },{
        header: getCommonTranslation('FINAL_RESULT'),
        dataIndex: 'finalResult',
        flex:1,
        sortable: true,
        editor:{
        	xtype: 'numberfield',
        	//maxValue: 100,
        	minValue: 0
        }, 
		renderer: function(val, rec) {
            if (isNullOrEmpty(val)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                return val;
            }
        }
    },{
        header: getCommonTranslation('SUBJECT_TARGET'),
        dataIndex: 'subjectTarget',
        flex:1,
        sortable: true,
        editor:{
        	xtype: 'numberfield',
        	//maxValue: 100,
        	minValue: 0
        }, 
		renderer: function(val, rec) {
            if (isNullOrEmpty(val)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                return val;
            }
        } 
    },{
        header: getCommonTranslation('ACHIEVED_MARKS_CURRENT'),
        dataIndex: 'achievedMarks',
        flex:1,
        sortable: true
    },{
        header: getCommonTranslation('ACHIEVED_ATTENDANCE_PERCENTAGE_CURRENT'),
        dataIndex: 'achievedAttendance',
        flex:1,
        sortable: true
    }],
    plugins: [
        Ext.create('Ext.grid.plugin.CellEditing', {
            clicksToEdit: 1,
    		listeners:{
    			beforeedit: function(editor, context){
    				var rowData=context.record.data;
    				if(context.column.getEditor() && (context.field == 'finalResult' || context.field == 'subjectTarget')){
    					context.column.getEditor().setMaxValue(rowData.maxMarks);
    				}
    				//if(context.field == 'finalResult' && !isNullOrEmpty(rowData.learningTargetDetailsId)){
    				//	return false;
    				//}
    				if(context.field == 'finalResult'){
    					if(!isNullOrEmpty(rowData.initialFinalResult)){  
    						return false;
    					}
    				}
    			}         
    		}
        })
    ],
    initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
  
});