/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.learningtarget.LearningTargetsReviewCoreForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.learningtargetsreviewcoreform',
    frame: false,
    plugins: "formlabelrequired",
    cls: 'x-form-fixed-footer-parent',
    items: [{
    	xtype:'fieldcontainer',
    	layout:'hbox',
    	width:'100%',
    	defaults: {
    		width: 256,
    		labelAlign: 'top'
    	},
    	items:[{
			xtype: 'datefield',
			name: 'reviewDate1',
			itemId: 'reviewDate1',
			vtype: 'daterange',
			endDateField: 'nextReviewDate1',
			fieldLabel: getCommonTranslation('REVIEW_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				},
				afterrender: function(field){
					field.setValue(new Date());
				}
			}
		},{
			xtype: 'datefield',
			name: 'nextReviewDate1',
			itemId: 'nextReviewDate1',
			vtype: 'daterange',
			startDateField: 'reviewDate1',
			fieldLabel: getCommonTranslation('NEXT_REVIEW_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]
    },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		width: 256,
    		labelAlign: 'top' 
    	},
    	items: [{
            xtype: 'textarea',
    	    maxLength: 250,
            name: 'teacherComment',
            itemId: 'teacherComment',
            fieldLabel: getCommonTranslation('TEACHER_COMMENT')
        },{
            xtype: 'textarea',
    	    maxLength: 250,
            name: 'principalComment',
            itemId: 'principalComment', 
            fieldLabel: getCommonTranslation('PRINCIPAL_COMMENT')  //Principal Comment     
        }]
    },  
       {
    	xtype: 'fieldcontainer',
    	width: '100%',
    	cls: 'form-fixed-footer',
		layout : {
			type : 'hbox'
		},
    	items: [{
    		xtype: 'button',
    		text: getCommonTranslation('SUBMIT'),
    		itemId: 'learningTargetSaveButtonId',
    		ui: 'CustomBtnSubmit',
    		scale: CONSTANTS.BUTTONSIZE,
    		disabled: true
    	},{
	        xtype: 'button',
    		text: getCommonTranslation('APPROVE_TARGETS'),
    		itemId: 'learningTargetApproveButtonId',   
    		ui: 'CustomBtnSubmit',
    		scale: CONSTANTS.BUTTONSIZE,
    		disabled: true 
	
}]
    }]
});