/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.leavemanagement.AddEligibilitySetting', {
	extend: 'Ext.form.FormPanel',
	alias : 'widget.addeligibilitysetting',
	autoScroll: false,
    modal: true,
    autoScroll:false,
    frame:true,
    title:getCommonTranslation('ADD_ELIGIBILITY_SETTINGS'),
//	plain: true,
    items : [{
    	xtype:'form',
    	plugins:"formlabelrequired",
    	items : [{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},
    		items:[{
			    xtype: 'hidden',
			    itemId:'idItemId',
			    name: 'id'
		    },{
    			xtype: 'textfield',
    			name: 'elegilibityCode',
    			fieldLabel:getCommonTranslation('ELIGIBILITY_CODE'),
    			allowBlank:false
    		},{
            	xtype: 'customcombobox',
                name: 'AvailabilityPeriod',
                itemId:'AvailabilityPeriodItemId',
                store:'leavemanagement.LeavePeriodEnumStore',
                displayField:'value',
                valueField:'id',
                forceSelection:true,
                editable:false,
                typeAhead:true,
                allowBlank:false,
                fieldLabel:getCommonTranslation('AVAILABILITY_PERIOD'),
            },{
				xtype: 'numberfield',
				name: 'availableLeaveDays',
				itemId: 'availableLeaveItemId',
				fieldLabel: getCommonTranslation('TOTAL_AVAIILABLE_LEAVE_DAYS'),
				minValue : 0,
				maxValue:100,
				allowBlank:false,
				allowDecimal:true
			}]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},
    		items:[{
    			xtype: 'customcombobox',
                name: 'periodStartFrom',
                itemId:'periodStartItemId',
                store:'leavemanagement.MonthsStore',
                displayField:'camelCaseValue',
                valueField:'id',
                forceSelection:true,
                editable:false,
                typeAhead:true,
                allowBlank:false,
                fieldLabel: getCommonTranslation('PERIOD_STARTS_FROM')
		},{
			xtype: 'numberfield',
			name: 'monthPeriodStart',
			disabled:true,
			fieldLabel: getCommonTranslation('DATE_STARTS_FROM'),
			minValue : 1,
			allowBlank:false,
			maxValue:31,
			allowDecimal:false
		},{
			xtype      : 'radiogroup',
			fieldLabel : getCommonTranslation('DIFFRENT_CREDIT_PERIOD'),
			itemId: 'diffrentCreditPeriodId',
			defaults: {
				flex: 1
			},
			layout: 'hbox',
			items:[{ 
				boxLabel: getCommonTranslation('YES'), 
				name: 'isDiffrentCreditPeriodId', 
				inputValue: true,
			},{ 
				boxLabel: getCommonTranslation('NO'), 
				name: 'isDiffrentCreditPeriodId', 
				inputValue: false,
				checked:true
			}]
		}]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},
    		items:[{
            	xtype: 'customcombobox',
                name: 'creditPeriodType',
                itemId:'creditPeriodTypeItemId',
                store:'leavemanagement.LeavePeriodEnumStore',
                displayField:'value',
                valueField:'id',
                disabled:true,
                allowBlank:false,
                forceSelection:true,
                editable:false,
                typeAhead:true,
                fieldLabel:getCommonTranslation('CREDIT_PERIOD_TYPE'),
            },{
				xtype: 'numberfield',
				name: 'leaveDaysToCredit',
				disabled:true,
				fieldLabel: getCommonTranslation('LEAVE_DAYS_TO_CREDIT'),
				minValue : 0,
				allowBlank:false,
				maxValue:100,
				allowDecimal:true
			},{
				xtype      : 'radiogroup',
				fieldLabel : getCommonTranslation('ALLOW_ADVANCE_CREDIT'),
				itemId: 'allowAdvanceCreditId',
				name:'allowAdvanceCredit',
				disabled:true,
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'isAllowAdvanceCredit', 
					inputValue: true,
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'isAllowAdvanceCredit', 
					inputValue: false,
					checked:true
				}]
			}]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},
    		items:[{
				xtype      : 'radiogroup',
				fieldLabel : getCommonTranslation('BASED_ON_JOINING'),
				itemId: 'basedOnJoiningDate',
				name:'reqDocsGrp',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'isBasedOnJoiningDate', 
					inputValue: true,
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'isBasedOnJoiningDate', 
					inputValue: false,
					checked:true
				}]
			},{
				xtype      : 'radiogroup',
				fieldLabel : getCommonTranslation('ELIGIBILE_FOR_COMP_OFF'),
				itemId: 'eligibleOfCompOff',
				name:'reqDocsGrp',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'isEligibleOfCompOff', 
					inputValue: true,
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'isEligibleOfCompOff', 
					inputValue: false,
					checked:true
				}]
			}]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},
    		items:[{
				xtype      : 'radiogroup',
				fieldLabel : getCommonTranslation('BASED_ON_SERVICE_PERIOD'),
				itemId: 'basedOnServicePeriod',
				name:'reqDocsGrp',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'isBasedOnServicePeriod', 
					inputValue: true,
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'isBasedOnServicePeriod', 
					inputValue: false,
					checked:true
				}]
			},{
            	xtype: 'customcombobox',
                name: 'servicePeriodType',
                itemId:'servicePeriodTypeItemId',
                store:'leavemanagement.LeavePeriodEnumStore',
                displayField:'value',
                valueField:'id',
                allowBlank:false,
                forceSelection:true,
                editable:false,
                typeAhead:true,
                fieldLabel:getCommonTranslation('SERVICE_PERIOD_TYPE'),
            },{
				xtype: 'numberfield',
				name: 'minimumServiceTerm',
				itemId: 'minimumServiceTermId',
				fieldLabel: getCommonTranslation('MINIMUM_SERVICE_TERM'),
				minValue : 0,
				maxValue:100,
				allowBlank:false,
				allowDecimal:true
			}]
    	},{
    		xtype: 'fieldcontainer',
    		width:'100%',
    		cls:'windowBtnPos',
    		items:[{
    			xtype: 'button',
    			itemId:'saveBtn',
    			text: getCommonTranslation('SUBMIT'),
    			ui: 'CustomBtnSubmit',
    			scale: CONSTANTS.BUTTONSIZE,
    			formBind:true
    		},{
	            xtype: 'button',
	            text: getCommonTranslation('RESET'),
	            itemId:'resetBtn',
	            ui: 'CustomBtnCancel',
	            scale: CONSTANTS.BUTTONSIZE
	        }]
    	}]
    }]
	});