/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.leavemanagement.EligilibitySettingForm', {
	extend: 'Ext.form.Panel',
    alias: 'widget.eligilibitysettingform',
    autoScroll: false,
    frame: false,
    standardSubmit: false,
    plugins:"formlabelrequired",
    cls:'customSearchPanel',
    items: [{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
        	xtype: 'customcombobox',
            name: 'EligibilityCodeType',
            itemId:'EligibilityCodeTypeItemId',
            store:'leavemanagement.EligibilityCodeStore',
            displayField:'value',
            valueField:'id',
            forceSelection:true,
            editable:false,
            typeAhead:true,
            fieldLabel:getCommonTranslation('ELIGIBILITY_CODE'),
        },{
        	xtype: 'customcombobox',
            name: 'AvailabilityPeriod',
            itemId:'AvailabilityPeriodItemId',
            store:'leavemanagement.LeavePeriodEnumStore',
            displayField:'value',
            valueField:'id',
            forceSelection:true,
            editable:false,
            typeAhead:true,
            fieldLabel:getCommonTranslation('AVAILABILITY_PERIOD'),
        }]
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'quickSearchId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true
        },{
        	xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});