/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.leavemanagement.LeaveTypeForm', {
	extend: 'Ext.form.Panel',
    alias: 'widget.leavetypeform',
    autoScroll: false,
    frame: false,
    standardSubmit: false,
    plugins:"formlabelrequired",
    cls:'customSearchPanel',
    items: [{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
        	xtype: 'customcombobox',
            name: 'HRLeaveType',
            itemId:'HRLeaveTypeItemId',
            store:'leavemanagement.LeaveTypeStore',
            displayField:'value',
            valueField:'id',
            forceSelection:true,
            editable:false,
            typeAhead:true,
            fieldLabel:getCommonTranslation('LEAVE_TYPE'),
        },{
        	xtype: 'customcombobox',
            name: 'HREligibility',
            itemId:'HREligibilityItemId',
            store:'leavemanagement.EligibilityEnumStore',
            displayField:'value',
            valueField:'id',
            forceSelection:true,
            editable:false,
            typeAhead:true,
            fieldLabel:getCommonTranslation('ELIGIBILITY_CRITERIA'),
        },{
        	xtype: 'customcombobox',
            name: 'status',
            itemId:'statusItemId',
            store:'common.StatusComboStore',
            displayField:'name',
            valueField:'id',
            forceSelection:true,
            editable:false,
            typeAhead:true,
            fieldLabel:getCommonTranslation('STATUS'),
        }]
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'quickSearchId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true
        },{
        	xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});