/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.leavemanagement.administrativeleave.AddAdminSettingView', {
	extend: 'Ext.form.FormPanel',
	alias : 'widget.addadminsettingview',
	autoScroll: false,
    modal: true,
    autoScroll:false,
    frame:true,
    title:getCommonTranslation('ADD_ELIGIBILITY_SETTINGS'),
//	plain: true,
    items : [{
    	xtype:'form',
    	plugins:"formlabelrequired",
    	items : [{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},
    		items:[{
    			xtype: 'textfield',
    			name: 'adminCode',
    			fieldLabel:getCommonTranslation('ADMINISTRATION_CODE'),
    			allowBlank:false
    		},{
            	xtype: 'customcombobox',
                name: 'leaveBalance',
                itemId:'leaveBalanceItemId',
                store:'leavemanagement.administrativeleave.LeaveBalanceFlagEnumStore',
                displayField:'value',
                valueField:'id',
                forceSelection:true,
                allowBlank:false,
                editable:false,
                typeAhead:true,
                fieldLabel:getCommonTranslation('LEAVE_BALANCE_FLAG'),
            },{
            	xtype: 'customcombobox',
                name: 'leaveBalanceUpdatePeriod',
                itemId:'leaveBalanceUpdatePeriodItemId',
                store:'leavemanagement.LeavePeriodEnumStore',
                displayField:'value',
                valueField:'id',
                forceSelection:true,
                editable:false,
                allowBlank:false,
                typeAhead:true,
                fieldLabel:getCommonTranslation('LEAVE_BALANCE_UPDATE_PERIOD'),
            }]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},
    		items:[{
				xtype      : 'radiogroup',
				fieldLabel : getCommonTranslation('LIMIT_LEAVES_TO_BALANCE'),
				itemId: 'limitLeavesToBalanceId',
				name:'limitLeavesToBalance',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'isLimitLeavesToBalance', 
					inputValue: true,
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'isLimitLeavesToBalance', 
					inputValue: false,
					checked:true
				}]
			},{
				xtype: 'numberfield',
				name: 'maxCarryFrwdDays',
				fieldLabel: getCommonTranslation('MAX_CARRY_FRWD_DAYS'),
				minValue : 0,
				allowBlank:false,
				maxValue:100,
				allowDecimal:true
			},{
				xtype: 'numberfield',
				name: 'maxLeaveBalance',
				fieldLabel: getCommonTranslation('MAX_LEAVE_BALANCE'),
				minValue : 0,
				allowBlank:false,
				maxValue:100,
				allowDecimal:true
			}]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},
    		items:[{
				xtype      : 'radiogroup',
				fieldLabel : getCommonTranslation('ENCAHS_EXCESS_LEAVE'),
				itemId: 'encashExcessLeaveId',
				name:'encashExcessLeave',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'isEncashExcessLeave', 
					inputValue: true,
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'isEncashExcessLeave', 
					inputValue: false,
					checked:true
				}]
			},{
				xtype: 'numberfield',
				name: 'minDaysToEncash',
				fieldLabel: getCommonTranslation('MIN_DAYS_TO_ENCAHS'),
				minValue : 0,
				allowBlank:false,
				maxValue:100,
				allowDecimal:true
			},{
				xtype: 'numberfield',
				name: 'minDaysToEncahsment',
				fieldLabel: getCommonTranslation('MAX_BALANCE_TO_ENCASHMENT'),
				minValue : 0,
				allowBlank:false,
				maxValue:100,
				allowDecimal:true
			}]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},
    		items:[{
				xtype: 'numberfield',
				name: 'balanceAfterEncahsment',
				fieldLabel: getCommonTranslation('BALANCE_AFTER_ENCASHMENT'),
				minValue : 0,
				allowBlank:false,
				maxValue:100,
				allowDecimal:true
			}]
    	},{
    		xtype: 'fieldcontainer',
    		width:'100%',
    		cls:'windowBtnPos',
    		items:[{
    			xtype: 'button',
    			itemId:'saveBtn',
    			text: getCommonTranslation('SUBMIT'),
    			ui: 'CustomBtnSubmit',
    			scale: CONSTANTS.BUTTONSIZE,
    			formBind:true
    		},{
	            xtype: 'button',
	            text: getCommonTranslation('RESET'),
	            itemId:'resetBtn',
	            ui: 'CustomBtnCancel',
	            scale: CONSTANTS.BUTTONSIZE
	        }]
    	}]
    }]
	});