/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.leavemanagement.administrativeleave.AdminSettingsGrid', {
	 //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.adminsettingsgrid',
    store: 'leavemanagement.administrativeleave.AdminGridStore',
    border: true,
    autoScroll: false,
    frame:false,
//    selType:'checkboxmodel',
    title:getCommonTranslation('ADMINISTRATION_SETTING_LIST'),
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selModel: {
//		 showHeaderCheckbox: true,
	     checkOnly : true, 
	     allowDeselect: false,
	
   },
   headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'administrativesettingfilter':1
		}
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
		        itemId:'managePaggingToolBarItemId',
	            plugins:['pagesize'],
			    store : 'leavemanagement.administrativeleave.AdminGridStore',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}
	],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
	    },{
	        xtype: 'button',
	        itemId: 'btnEdit',
	        tooltip: getCommonTranslation('EDIT'),
	        glyph: ICONGLYPH.EDITGLYPH
	    
	   },{	
		xtype:'fieldcontainer',
		layout : 'hbox',
		cls:'windowBtnPos',
		defaults: {
			labelAlign:'top',
		},
		items:[{
			xtype: 'button',
			itemId: 'btnApplyToItemId',
			tooltip: getExaminationTranslation('APPLY_TO'),
			ui: 'CustomBtnSubmit',
	        scale: CONSTANTS.BUTTONSIZE,
			text:getExaminationTranslation('APPLY_TO'),
			style:{
//					marginLeft:'5px',
					marginRight:'10px'
			}
		}]
	}],
    columns: [{
    	header: getExaminationTranslation('S_NO'),
    	xtype: 'rownumberer',
        sortable: false,
        align:'center',
        flex:.2,
        locked: false,
        hidden:true
    },{
        header:getCommonTranslation('ADMINISTRATION_CODE'),
        dataIndex: 'administrationCode',
        flex:.4,
        sortable:true
    }, {
        header: getCommonTranslation('LEAVE_BALANCE_FLAG'),
        dataIndex: 'leaveBalanceFlag',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			} else {
				return "-";
			}      
        }
    }, {
        header: getCommonTranslation('CALCULATION_PERIOD'),
        dataIndex: 'leaveBalanceUpdatePeriod',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			} else {
				return "-";
			}                     
        }
    }, {
        header: getCommonTranslation('LIMIT_BALANCING'),
        dataIndex: 'isLimitLeavesToBalance',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(value){
					return "<span style=\'color:green\'>Yes</span>";
				} else {
					return "<span style=\'color:red\'>No</span>";
				}            
			} else {
				return "-";
			}        
        }
    },{
        header: getCommonTranslation('MAX_DAYS'),
        dataIndex: 'minDaysToEncash',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return value;
			} else {
				return "-";
			}                   
        }
    }, {
        header: getCommonTranslation('MAX_LEAVES'),
        dataIndex: 'maxLeaveBalance',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return value;
			} else {
				return "-";
			}                   
        }
    }]
});